<div id="program" class="form-body p-3 mt-3 position-relative">
    <h2>
        {!! strtoupper('chosen structure program') !!}
    </h2>
    <div class="row-2">
        <div class="form-row">
            <label for="class-id">{!! strtoupper('Structure program id') !!}</label>
            <select id="class-id" disabled>
                <option value="">{!! $data->class_structure_program->structure_program->id ?
                    $data->class_structure_program->structure_program->id : '--' !!}</option>
            </select>
        </div>
        <div class="form-row">
            <label for="class-id">{!! strtoupper('Structured program occupation') !!}</label>
            <select id="class-id" disabled>
                <option value="">{!! $data->class_structure_program->structure_program->class_occupation->name ?
                    $data->class_structure_program->structure_program->class_occupation->name : '--' !!}</option>
            </select>
        </div>
    </div>
    <div class="row-2">
        <div class="form-row">
            <label for="class-id">{!! strtoupper('Structured program description') !!}</label>
            <select id="class-id" disabled>
                <option value="">{!! $data->class_structure_program->structure_program->description ?
                    $data->class_structure_program->structure_program->description : '--' !!}</option>
            </select>
        </div>
        <div class="button">
            <span>Action</span>
            @can('structure-program-view-info')
            <button class="btn-create bg-primary w-100" @click="openStructureProgram()">
                <span class="w-100">{!! strtoupper('View structured program') !!}</span>
            </button>
            @endcan
            <button class="btn-create bg-primary w-100 mt-1" @click="dialogClassLog()">
                <span class="w-100">{!! strtoupper('view class log') !!}</span>
            </button>
        </div>
    </div>
    <div class="row">
        <div class="table">
            <div class="table-wrapper">
                <div class="table-header bg-black text-light font-sm">
                    <div class="row table-row-7">
                        <span class="font-sm">{!! strtoupper('Pro. Detail ID') !!}</span>
                    </div>
                    <div class="row table-row-6">
                        <span class="font-sm">{!! strtoupper('Lesson ID') !!}</span>
                    </div>
                    <div class="row table-row-20">
                        <span class="font-sm">{!! strtoupper('Lesson Name') !!}</span>
                    </div>
                    <div class="row table-row-10">
                        <span class="font-sm">{!! strtoupper('Short Name') !!}</span>
                    </div>
                    <div class="row table-row-10">
                        <span class="font-sm">{!! strtoupper('Lesson Occupation') !!}</span>
                    </div>
                    <div class="row table-row-10">
                        <span class="font-sm">{!! strtoupper('Practice hrs') !!}</span>
                    </div>
                    <div class="row table-row-10">
                        <span class="font-sm">{!! strtoupper('Theory hrs') !!}</span>
                    </div>
                    <div class="row table-row-7">
                        <span class="font-sm">{!! strtoupper('Attend Count') !!}</span>
                    </div>
                    <div class="row table-row-10">
                        <span class="font-sm">{!! strtoupper('Progress') !!}</span>
                    </div>
                    <div class="row table-row-10">
                        <span class="font-sm">{!! strtoupper('Progress %') !!}</span>
                    </div>
                </div>
                <div class="table-body overflow-auto">
                    @php
                    $sum_P = 0;
                    $sum_T = 0;
                    $sum_D = 0;
                    $sum_PP = 0;
                    $sum_A = 0;
                    @endphp
                    @foreach($lessons as $lesson)
                    <div class="column">
                        <div class="row table-row-7">
                            <span>{!! $data->id ? $data->id : '--' !!}</span>
                        </div>
                        <div class="row table-row-6">
                            <span>{!! $lesson->id ? $lesson->id : '--' !!}</span>
                        </div>
                        <div class="row table-row-20">
                            <span>{!! $lesson->name ? $lesson->name : '--' !!}</span>
                        </div>
                        <div class="row table-row-10">
                            <span>{!! $lesson->short_name ? $lesson->short_name : '--' !!}</span>
                        </div>
                        <div class="row table-row-10">
                            <span>{!! $lesson->occupation->name ? $lesson->occupation->name : '--' !!}</span>
                        </div>
                        <div class="row table-row-10">
                            <span>{!! $lesson->practice_hour ? $lesson->practice_hour : '0' !!}</span>
                        </div>
                        <div class="row table-row-10">
                            <span>{!! $lesson->theory_hour ? $lesson->theory_hour : '0' !!}</span>
                        </div>
                        <div class="row table-row-7">
                            <span>{{ $lesson->attendance ? count($attendances->where('lesson_id', $lesson->id)) : '0'
                                }}</span>
                        </div>
                        <div class="row table-row-10">
                            <span>
                                {{ $lesson->practice_hour && $lesson->attendance ?
                                count($attendances->where('lesson_id', $lesson->id)).'/'.round($lesson->practice_hour/3)
                                :
                                '0' }}
                            </span>
                        </div>
                        <div class="row table-row-10">
                            <span>{{round((count($attendances->where('lesson_id',
                                $lesson->id))/round($lesson->practice_hour/3))*100)}}.00 %</span>
                        </div>
                    </div>
                    @php
                    $sum_P += $lesson->practice_hour;
                    $sum_T += $lesson->theory_hour;
                    $sum_D += round($lesson->practice_hour/3);
                    $sum_A += count($attendances->where('lesson_id', $lesson->id));
                    $sum_PP += round((count($attendances->where('lesson_id',
                    $lesson->id))/round($lesson->practice_hour/3))*100);
                    @endphp
                    @endforeach
                </div>
                <div class="table-header bg-black text-light font-sm border-bl-br">
                    <div class="row table-row-53">
                        <span class="font-sm">{!! strtoupper('total') !!}</span>
                    </div>
                    <div class="row table-row-10">
                        <span class="font-sm">{!! $sum_P. ' hrs | '. round($sum_P/3).' day(s)'!!}</span>
                    </div>
                    <div class="row table-row-10">
                        <span class="font-sm">{!! $sum_T. ' hrs | '. round($sum_T/3).' day(s)'!!}</span>
                    </div>
                    <div class="row table-row-7">
                        <span class="font-sm">{{$sum_A}} day(s)</span>
                    </div>
                    <div class="row table-row-10">
                        <span class="font-sm">{{$sum_A.'/'.$sum_D. ' day(s)'}}</span>
                    </div>
                    <div class="row table-row-10">
                        <span class="font-sm">{{round($sum_PP/count($lessons))}}.00 %</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @include('admin::pages.class.view-info.modal.class-log')
    @include('admin::pages.class.view-info.modal.view-structure-program')
    {{-- <template x-if="dialogOpen">--}}
        {{-- <div class="classLogDialogLayout">--}}
            {{-- <div class="classLogDialog">--}}
                {{-- <button @click="dialogOpen=false">CLose</button>--}}

                {{-- <p>jo</p>--}}
                {{-- </div>--}}
            {{-- </div>--}}
        {{-- </template>--}}
</div>