<div id="study-intern" class="form-body p-3 mt-3">
    <h2>
        {!! strtoupper('Student study intern') !!}
    </h2>
    <div class="row">
        <div class="form-row flex-row">
            <button class="btn-create bg-primary mr-2 w-100 m-0"
                s-click-link="{{route('admin-assign-internship-place-listing', request('id'))}}">
                <span class="w-100">{!! strtoupper('Manage intern place') !!}</span>
            </button>
        </div>
    </div>
    <div class="row">
        <div class="table">
            <div class="table-wrapper">
                <div class="table-header bg-black text-light">
                    <div class="row table-row-10">
                        <span class="font-sm">{!! strtoupper('student id') !!}</span>
                    </div>
                    <div class="row table-row-15">
                        <span class="font-sm">{!! strtoupper('Name') !!}</span>
                    </div>
                    <div class="row table-row-15">
                        <span class="font-sm">{!! strtoupper('internship place') !!}</span>
                    </div>
                    <div class="row table-row-20">
                        <span class="font-sm">{!! strtoupper('location') !!}</span>
                    </div>
                    <div class="row table-row-15">
                        <span class="font-sm">{!! strtoupper('phone number') !!}</span>
                    </div>
                    <div class="row table-row-10">
                        <span class="font-sm">{!! strtoupper('register date') !!}</span>
                    </div>

                    <div class="row table-row-10">
                        <span class="font-sm">{!! strtoupper('interned status') !!}</span>
                    </div>
                    <div class="row table-row-5">
                        <span class="font-sm"></span>
                    </div>
                </div>
                <div class="table-body overflow-auto">
                    @foreach($student_intern->sortBy('student_id') as $item)
                    <div class="column">
                        <div class="row table-row-10">
                            <span class="font-sm">
                                {{ $item->student_id ?? '--' }}
                            </span>
                        </div>
                        <div class="row table-row-15">
                            <span class="font-sm">
                                {{$item->student->name_khmer ?? '--' }}
                            </span>
                        </div>
                        <div class="row table-row-15">
                            <span class="font-sm">
                                {{$item->internship_place->place_name ?? '--' }}
                            </span>
                        </div>
                        <div class="row table-row-20">
                            <span class="font-sm">
                                {{$item->internship_place->location ?? '--' }}
                            </span>
                        </div>
                        <div class="row table-row-15">
                            <span class="font-sm">
                                {{$item->internship_place->contact_number ?? '--'}}
                            </span>
                        </div>
                        <div class="row table-row-10">
                            <span class="font-sm">
                                {{$item->start_date ?? '--'}}
                            </span>
                        </div>
                        <div class="row table-row-10">
                            <span class="font-sm {{ $item->is_intern_pass == 1 ? 'text-success' : 'text-danger'}}">
                                {{
                                $item->is_intern_pass == 1
                                ? 'Passed'
                                : 'Failed'
                                }}
                            </span>
                        </div>
                        <div class="row table-row-5">
                            <div class="dropdown">
                                <i data-feather="more-vertical" class="action-btn" id="dropdownMenuButton"
                                    data-mdb-toggle="dropdown" aria-expanded="false">
                                </i>
                                <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                    @if ($item->is_intern_pass == 0)
                                    <li>
                                        <a class="dropdown-item enable-btn" onclick="$onConfirmMessage(
                                                                '{!! route('admin-assign-internship-place-status', ['id' => $item->id, 'status' => 1]) !!}',
                                                                'Do you want to let {{$item->student->name_khmer}} pass internship?',
                                                                {
                                                                    confirm: '@lang('dialog.button.ok')',
                                                                    cancel: '@lang('dialog.button.cancel')'
                                                                },
                                                            );">
                                            <i data-feather="rotate-ccw"></i>
                                            <span>Assign to Pass</span>
                                        </a>
                                    </li>
                                    @else
                                    <li>
                                        <a class="dropdown-item disable-btn" onclick="$onConfirmMessage(
                                                                '{!! route('admin-staff-type-status', ['id' => $item->id, 'status' => 0]) !!}',
                                                                'Do you want to let {{$item->student->name_khmer}} fail internship?',
                                                                {
                                                                    confirm: '@lang('dialog.button.ok')',
                                                                    cancel: '@lang('dialog.button.cancel')'
                                                                }
                                                            );">
                                            <i data-feather="rotate-ccw"></i>
                                            <span>Assign to Fail</span>
                                        </a>
                                    </li>
                                    @endif
                                </ul>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>