<div id="study-note" class="form-body p-3 mt-3">
    <h2>
        {!! strtoupper('study note') !!}
    </h2>
    <div class="row">
        <div class="table">
            <div class="table-wrapper">
                <div class="table-header bg-black text-light">
                    <div class="row table-row-10">
                        <span class="font-sm">{!! strtoupper('student id') !!}</span>
                    </div>
                    <div class="row table-row-20">
                        <span class="font-sm">{!! strtoupper('name kh') !!}</span>
                    </div>
                    <div class="row table-row-60">
                        <span class="font-sm">{!! strtoupper('description') !!}</span>
                    </div>
                    <div class="row table-row-10">
                        <span class="font-sm">{!! strtoupper('action') !!}</span>
                    </div>
                </div>
                <div class="table-body overflow-auto">
                    @foreach($data->students as $student)
                    <div class="column h-auto" style="min-height: 80px;">
                        <div class="row table-row-10">
                            <span class="font-sm">{!! $student->id !!}</span>
                        </div>
                        <div class="row table-row-20">
                            <span class="font-sm">{!! $student->name_khmer !!}</span>
                        </div>
                        <div class="row table-row-60 text left">
                            @if($student->study_notes && count($student->study_notes->where('class_id', $data->id)))
                            @foreach($student->study_notes->sortBy('noted_date') as $note)
                            @if($note->class_id == $data->id)
                            <div class="d-flex flex-row align-items-center">
                                <span style="margin-right: 1rem" class="cursor-pointer">
                                    <a class="dropdown-item enable-btn text-danger" onclick="$onConfirmMessage(
                                        '{!! route('admin-study-note-delete', ['id' => $note->id]) !!}',
                                        'Are you sure you want to delete {{$note->noted_date}}?',
                                        {
                                            confirm: 'Delete',
                                            cancel: '@lang('dialog.button.cancel')'
                                        },
                                    );">
                                        <span>Delete</span>
                                    </a>
                                </span>
                                <span class="font-sm d-flex flex-row">
                                    [ {{$note->noted_date. ' - '. $note->description}} ]
                                </span>
                            </div>
                            @endif
                            @endforeach
                            @else
                            --
                            @endif
                        </div>
                        <div class="row table-row-10 h-100 d-flex justify-content-center align-items-center"
                            style="height: 80px !important;">
                            <span class="font-sm h-50">
                                <button class="btn-create bg-primary h-100"
                                    @click="dialogCreateStudyNote({{$student->id}}, {{$data->id}})">
                                    <span>{!! strtoupper('Entry') !!}</span>
                                </button>
                            </span>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
    @include('admin::pages.class.view-info.modal.create-study-note')
</div>