<div class=" form-body w-50 border-1-gray p-2" style="margin-right: 5px;">
    <div>
        <h2 class="mt-0">{{strtoupper('Exam Candidates')}}</h2>
    </div>
    <div class="d-flex justify-content-between mb-3">
        <div>
            <span class="h-50">
                <button class="btn-create bg-primary h-100" @click="dialogOpenCandidate({{request('class_id')}})">
                    <span>{!! strtoupper('add new candidates') !!}</span>
                </button>
            </span>
        </div>
        <div>
            <span class="h-50">
                <button class="btn-create bg-primary h-100">
                    <span>{!! strtoupper('Print exam candidate') !!}</span>
                </button>
            </span>
        </div>
    </div>
    <div>
        <div>
            <span>Exam id: <span x-text="exam_detail_id"></span></span>
        </div>
        <div>
            <span>Result Count: <span x-text="exam_candidate.length"></span></span>
        </div>
    </div>
    <div class=" table">
        <div class="table-wrapper">
            <div class="table-header bg-black text-light">
                <div class="row table-row-10">
                    <span class="font-sm">{{strtoupper('N°')}}</span>
                </div>
                <div class=" row table-row-10">
                    <span class="font-sm">{{strtoupper('EC id')}}</span>
                </div>
                <div class=" row table-row-10">
                    <span class="font-sm">{{strtoupper('id')}}</span>
                </div>
                <div class=" row table-row-35">
                    <span class="font-sm">{{strtoupper('student name')}}</span>
                </div>
                <div class=" row table-row-35">
                    <span class="font-sm">{{strtoupper('student tel')}}</span>
                </div>
            </div>
            <div class="table-body h-auto overflow-auto">
                <template x-if="exam_candidate.length > 0">
                    <template x-for="(data, index) in exam_candidate">
                        <div class="column">
                            <div class="row table-row-10">
                                <span class="font-sm" x-text="index+1"></span>
                            </div>
                            <div class=" row table-row-10">
                                <span class="font-sm" x-text="data.exam_id"></span>
                            </div>
                            <div class=" row table-row-10">
                                <span class="font-sm" x-text="data.student_id"></span>
                            </div>
                            <div class=" row table-row-35">
                                <span class="font-sm" x-text="data.student.name_khmer"></span>
                            </div>
                            <div class=" row table-row-35">
                                <span class="font-sm" x-text="data.student.phone"></span>
                            </div>
                        </div>
                    </template>
                </template>
                <template x-if="exam_candidate.length < 1">
                    <div class="column">
                        <div class="row table-row-100">
                            <span class="font-sm text-danger font-weight-bolder">{{strtoupper('No data!')}}</span>
                        </div>
                    </div>
                </template>
            </div>
        </div>
    </div>
</div>