<div class="form-body w-50 border-1-gray p-2" style="margin-right: 5px;">
    <div>
        <h2 class="mt-0">{{strtoupper('Exam Subject List')}}</h3>
    </div>
    <div class="mb-3">
        <span class="h-50">
            <button class="btn-create bg-primary h-100" @click="dialogOpenCreateESubject()">
                <span>{!! strtoupper('add new exam subject') !!}</span>
            </button>
        </span>
    </div>
    <div>
        <span>
            Exam id: <span x-text="exam_detail_id"></span>
        </span>
    </div>
    <div class="table">
        <div class="table-wrapper">
            <div class="table-header bg-black text-light">
                <div class="row table-row-15">
                    <span class="font-sm">{{strtoupper('subject id')}}</span>
                </div>
                <div class=" row table-row-40">
                    <span class="font-sm">{{strtoupper('subject name')}}</span>
                </div>
                <div class=" row table-row-40">
                    <span class="font-sm">{{strtoupper('issuer name')}}</span>
                </div>
                <div class=" row table-row-5">
                </div>
            </div>
            <div class="table-body h-auto overflow-visible">
                <template x-if="exam_subject.length > 0">
                    <template x-for="data in exam_subject">
                        <div class="column">
                            <div class="row table-row-15">
                                <span class="font-sm" x-text="data.id"></span>
                            </div>
                            <div class="row table-row-40">
                                <span class="font-sm" x-text="data.description"></span>
                            </div>
                            <div class="row table-row-40">
                                <span class="font-sm" x-text="data.staff.full_name"></span>
                            </div>
                            <div class="row table-row-5">
                                @canany(['exam-subject-update', 'exam-subject-delete'])
                                <div class="dropdown">
                                    <i data-feather="more-vertical" class="action-btn" id="dropdownMenuButton"
                                        data-mdb-toggle="dropdown" aria-expanded="false">
                                    </i>
                                    <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                        @if (1==1)
                                        @can('exam-subject-view-detail')
                                        <li>
                                            <a class="dropdown-item">
                                                <i data-feather="edit"></i>
                                                <span>View Detail</span>
                                            </a>
                                        </li>
                                        @endcan
                                        @can('exam-subject-update')
                                        <li>
                                            <a class="dropdown-item" @click="dialogOpenUpdateESubject(data.id)">
                                                <i data-feather="edit"></i>
                                                <span>Edit</span>
                                            </a>
                                        </li>
                                        @endcan
                                        @can('exam-subject-delete')
                                        <li>
                                            <a class="dropdown-item disable-btn" onclick="$onConfirmMessage(
                                                    '{{route('admin-exam-subject-delete', 1)}}',
                                                    '@lang('dialog.msg.delete', ['name' => 1])',
                                                    {
                                                    confirm: '@lang('dialog.button.delete')',
                                                    cancel: '@lang('dialog.button.cancel')'
                                                    }
                                                    );">
                                                <i data-feather="trash-2"></i>
                                                <span>Delete</span>
                                            </a>
                                        </li>
                                        @endcan
                                        @endif
                                    </ul>
                                </div>
                                @endcan
                            </div>
                        </div>
                    </template>
                </template>
                <template x-if="exam_subject.length < 1">
                    <div class="column">
                        <div class="row table-row-100">
                            <span class="font-sm text-danger font-weight-bolder">{{strtoupper('No data!')}}</span>
                        </div>
                    </div>
                </template>
            </div>
        </div>
    </div>
</div>