<div id="exam-list" class="bg-white mb-3 mt-3">
    <div id="student-list" class="form-body p-3">
        <h2 class="mt-0">
            {!! strtoupper('Exam list') !!}
        </h2>
        <div class="row d-flex justify-content-between align-items-center">
            <div>
                <div>
                    <span>
                        Result Count: <span class="text-primary">{{count($data)}}</span>
                    </span>
                </div>
                <div>
                    <span>
                        Class ID: <span class="text-primary">{{request('class_id')}}</span>
                    </span>
                </div>
            </div>
            <div>
                <span class="h-50">
                    <button class="btn-create bg-primary h-100" @click="dialogOpenCreate()">
                        <span>{!! strtoupper('add new exam to class') !!}</span>
                    </button>
                </span>
            </div>
        </div>
        <div class="row">
            <div class="table">
                <div class="table-wrapper">
                    <div class="table-header bg-black text-light">
                        <div class="row table-row-5">
                            <span class="font-sm">{!! strtoupper('exam id') !!}</span>
                        </div>
                        <div class="row table-row-15">
                            <span class="font-sm">{!! strtoupper('exam date') !!}</span>
                        </div>
                        <div class="row table-row-10">
                            <span class="font-sm">{!! strtoupper('exam type') !!}</span>
                        </div>
                        <div class="row table-row-10">
                            <span class="font-sm">{!! strtoupper('duration') !!}</span>
                        </div>
                        <div class="row table-row-10">
                            <span class="font-sm">{!! strtoupper('candidate') !!}</span>
                        </div>
                        <div class="row table-row-15">
                            <span class="font-sm">{!! strtoupper('exam subject') !!}</span>
                        </div>
                        <div class="row table-row-15">
                            <span class="font-sm">{!! strtoupper('exam note') !!}</span>
                        </div>
                        <div class="row table-row-15">
                            <span class="font-sm">{!! strtoupper('class status') !!}</span>
                        </div>
                        <div class="row table-row-5">
                            <span class="font-sm"></span>
                        </div>
                    </div>
                    <div class="table-body overflow-visible">
                        @foreach($data as $index => $item)
                        <div class="column">
                            <div class="row table-row-5">
                                <span class="font-sm">{!! $item->id !!}</span>
                            </div>
                            <div class="row table-row-15">
                                <span class="font-sm">{!! date('Y-m-d', strtotime($item->exam_date)) !!}</span>
                            </div>
                            <div class="row table-row-10">
                                <span class="font-sm">{!! $item->exam_type->name !!}</span>
                            </div>
                            <div class="row table-row-10">
                                <span class="font-sm">{!! $item->duration !!} day(s)</span>
                            </div>
                            <div class="row table-row-10">
                                <span class="font-sm">{{count($item->exam_candidates)}}</span>
                            </div>
                            <div class="row table-row-15">
                                <span class="font-sm">{!! strtoupper('exam subject') !!}</span>
                            </div>
                            <div class="row table-row-15">
                                <span class="font-sm">{!! $item->noted !!}</span>
                            </div>
                            <div class="row table-row-15">
                                <span class="font-sm">{!! $item->classes->class_status->name !!}</span>
                            </div>
                            <div class="row table-row-5">
                                @canany(['exam-control-update', 'exam-control-delete'])
                                <div class="dropdown">
                                    <i data-feather="more-vertical" class="action-btn" id="dropdownMenuButton"
                                        data-mdb-toggle="dropdown" aria-expanded="false">
                                    </i>
                                    <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                        @if ($item->status != 'trash')
                                        @can('exam-control-view-detail')
                                        <li>
                                            <a class="dropdown-item"
                                                @click="dialogExamDetail({{$item->id}}, {{request('class_id')}})">
                                                <i data-feather="edit"></i>
                                                <span>View Detail</span>
                                            </a>
                                        </li>
                                        @endcan
                                        @can('exam-control-update')
                                        <li>
                                            <a class="dropdown-item" @click="dialogOpenUpdate({{$item->id}})">
                                                <i data-feather="edit"></i>
                                                <span>Edit</span>
                                            </a>
                                        </li>
                                        @endcan
                                        @can('exam-control-delete')
                                        <li>
                                            <a class="dropdown-item disable-btn" onclick="$onConfirmMessage(
                                                '{{route('admin-exam-control-delete', $item->id)}}',
                                                '@lang('dialog.msg.delete', ['name' => $item->noted])',
                                                {
                                                confirm: '@lang('dialog.button.delete')',
                                                cancel: '@lang('dialog.button.cancel')'
                                                }
                                                );">
                                                <i data-feather="trash-2"></i>
                                                <span>Delete</span>
                                            </a>
                                        </li>
                                        @endcan
                                        @can('exam-control-add-answer-sheet')
                                        <li>
                                            <a class="dropdown-item"
                                                s-click-link="{!! route('admin-exam-control-add-answer-sheet', $item->id) !!}">
                                                <i data-feather="edit"></i>
                                                <span>Add Answer Sheet</span>
                                            </a>
                                        </li>
                                        @endcan
                                        @can('exam-control-exam-score-table')
                                        <li>
                                            <a class="dropdown-item"
                                                s-click-link="{!! route('admin-exam-control-exam-score-table', $item->id) !!}">
                                                <i data-feather="edit"></i>
                                                <span>Exam Score Table</span>
                                            </a>
                                        </li>
                                        @endcan
                                        @endif
                                    </ul>
                                </div>
                                @endcan
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>