<template x-if="dialogOpen">
    <div class="classLogDialogLayout">
        <div class="classLogDialog p-3 h-auto">
            <div class="form-admin p-3">
                <form id="form" class="form-wrapper p-0"
                    action="{!! route('admin-group-save', ['class_id' => request('class_id')]) !!}" method="POST"
                    enctype="multipart/form-data">
                    <div class="form-body p-0" style="box-shadow: none">
                        <div class="row">
                            <h2 class="mt-0">
                                Create Student Group
                            </h2>
                        </div>
                        {{ csrf_field() }}
                        <div class="row">
                            <div class="form-row">
                                <label>Group Name <span>*</span></label>
                                <input type="text" name="name">
                            </div>
                            @error('name')
                            <span class="error">{{$message}}</span>
                            @enderror
                        </div>
                        <div class="form-button">
                            <button type="submit" color="primary">
                                <i data-feather="save"></i>
                                <span>Submit</span>
                            </button>
                            <button color="danger" type="button" @click="dialogOpen=false">
                                <i data-feather="x"></i>
                                <span>Cancel</span>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</template>