<template x-if="dialogViewInfo">
    <div class="classLogDialogLayout">
        <div class="classLogDialog">
            <div class="content-body d-flex flex-column overflow-auto h-100">
                <div id="student-internship-place" class="bg-white mb-3">
                    <div id="student-list" class="form-body p-3">
                        <div class="form-button d-flex justify-content-between align-items-center">
                            <h2>
                                {!! strtoupper('Groups in class') !!}
                            </h2>
                            <div class="d-flex justify-content-end align-items-center">
                                <button color="danger" type="button" @click="dialogViewInfo=false" class="bg-danger">
                                    <span>Close</span>
                                </button>
                            </div>
                        </div>
                        <div class="row d-flex align-items-center justify-content-between">
                            <div>
                                <span>
                                    {{strtoupper('selected class id: ').request('class_id')}}
                                </span>
                                <br />
                                <span>
                                    {{strtoupper('selected group id: ')}} <span x-text="groupId"></span>
                                </span>
                            </div>
                        </div>
                        <div class="row">
                            <div class="table">
                                <div class="table-wrapper">
                                    <div class="table-header bg-black text-light">
                                        <div class="row table-row-10">
                                            <span class="font-sm">{!! strtoupper('group id') !!}</span>
                                        </div>
                                        <div class="row table-row-10">
                                            <span class="font-sm">{!! strtoupper('student id') !!}</span>
                                        </div>
                                        <div class="row table-row-25">
                                            <span class="font-sm">{!! strtoupper('name') !!}</span>
                                        </div>
                                        <div class="row table-row-25">
                                            <span class="font-sm">{!! strtoupper('phone') !!}</span>
                                        </div>
                                        <div class="row table-row-30">
                                            <span class="font-sm">{!! strtoupper('image') !!}</span>
                                        </div>
                                    </div>
                                    <div class="table-body overflow-auto">
                                        <template x-for="data in studentInGroup">
                                            <div class="column h-4cm">
                                                <div class="row table-row-10">
                                                    <span class="font-sm" x-text="groupId"></span>
                                                </div>
                                                <div class="row table-row-10">
                                                    <span class="font-sm" x-text="data.id">{!! strtoupper('student id')
                                                        !!}</span>
                                                </div>
                                                <div class="row table-row-25">
                                                    <span class="font-sm" x-text="data.name_khmer"></span>
                                                </div>
                                                <div class="row table-row-25">
                                                    <span class="font-sm" x-text="data.phone"></span>
                                                </div>
                                                <div
                                                    class="row table-row-30 h-100 d-flex justify-content-center align-items-center">
                                                    <div class="thumbnail h-100 w-3cm" data-fancybox
                                                        x-bind:data-src="'{{ asset('file_manager')}}' + data.profile">
                                                        <img x-bind:src="'{{ asset('file_manager')}}' + data.profile"
                                                            onerror="(this).src='{{ asset('images/logo/default.png') }}'"
                                                            alt="">
                                                    </div>
                                                </div>
                                            </div>
                                        </template>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</template>