@extends('admin::shared.layout')
@section('layout')
    <div class="form-admin" x-data="xService">
        <div class="form-bg"></div>
        <form id="form" class="form-wrapper" action="{!! route('admin-internship-place-save',request('id')) !!}" method="POST" enctype="multipart/form-data">
            <div class="form-header">
                <h3>
                    <i data-feather="arrow-left" s-click-link="{!! route('admin-internship-place-list', 1) !!}"></i>
                    Create Internship Place
                </h3>
            </div>
            {{ csrf_field() }}
            <div class="form-body">
                <div class="row-2">
                    <div class="form-row">
                        <label>Name<span>*</span></label>
                        <input type="text" name="place_name" placeholder="" value="{!! request('id') ? $data->place_name : old('place_name') !!}">
                        @error('place_name')
                            <label class="error">{{ $message }}</label>
                        @enderror
                    </div>
                    <div class="form-row">
                        <label>Phone<span>*</span></label>
                        <input type="text" name="contact_number" placeholder="" value="{!! request('id') ? $data->contact_number : old('contact_number') !!}">
                        @error('contact_number')
                            <label class="error">{{ $message }}</label>
                        @enderror
                    </div>
                </div>
                <div class="row">
                    <div class="form-row">
                        <label>Location</label>
                        <textarea name="location" placeholder="">{!! request('id') ? $data->location : old('location') !!}</textarea>
                        @error('location')
                        <span class="error">@lang("message.".$message)</span>
                        @enderror
                    </div>
                </div>
                <div class="form-button">
                    <button type="submit" color="primary">
                        <i data-feather="save"></i>
                        <span>Submit</span>
                    </button>
                    <button color="danger" type="button" s-click-link="{!! route('admin-internship-place-list', 1) !!}">
                        <i data-feather="x"></i>
                        <span>Cancel</span>
                    </button>
                </div>
            </div>
            <div class="form-footer"></div>
        </form>
    </div>
@stop
@section('script')
    <script lang="ts">
    $(document).ready(function() {
        $validator("#form", {
            place_name: {
                required: true,
            },
            contact_number:{
                required: true,
            },
            status: {
                required: true,
                status: true,
            },
        });
    });
    </script>
    <script>
        const header = {
            headers: {
                "Content-Type": "application/x-www-form-urlencoded;charset=utf-8",
                Accept: "application/json",
            },
            responseType: "json",
        };
        document.addEventListener('alpine:init', () => {
            Alpine.data("xService", () => ({}));
        });
    </script>
@stop
