@extends('admin::shared.layout')
@section('layout')
<div class="form-admin">
    <div class="form-bg"></div>
    <form id="form" class="form-wrapper" action="{!! route('admin-student-assign-class', request('id')) !!}"
        method="POST" enctype="multipart/form-data">
        <div class="form-header">
            <h3>
                <i data-feather="arrow-left" s-click-link="{!! route('admin-student-list', 1) !!}"></i>
                Assign Student to Class
            </h3>
        </div>
        {{ csrf_field() }}
        <div class="form-body">
            <div class="row-2">
                <div class="form-row">
                    <label>Selected student name</label>
                    <select disabled>
                        <option>
                            {!! $data->name_khmer ?? '--'!!}
                        </option>
                    </select>
                </div>
                <div class="form-row">
                    <label>Selected student ID</label>
                    <select disabled>
                        <option>
                            {!! $data->id_card ?? '--'!!}
                        </option>
                    </select>
                </div>
            </div>
            <div class="table-wrapper">
                <span>STUDY HISTORY RECORD</span>
                <div class="table-header bg-black text-light">
                    <div class="row table-row-10">
                        <span>{!! strtoupper("Class ID") !!}</span>
                    </div>
                    <div class="row table-row-15">
                        <span>{!! strtoupper("Occupation") !!}</span>
                    </div>
                    <div class="row table-row-15">
                        <span>{!! strtoupper("Trainer") !!}</span>
                    </div>
                    <div class="row table-row-25">
                        <span>{!! strtoupper("Shift") !!}</span>
                    </div>
                    <div class="row table-row-15">
                        <span>{!! strtoupper("Level") !!}</span>
                    </div>
                    <div class="row table-row-20">
                        <span>{!! strtoupper("Proc.Status") !!}</span>
                    </div>
                </div>
                <div class="table-body">
                    @foreach($data->classes as $item)
                    <div class="column">
                        <div class="row table-row-10">
                            <span>{!! $item->id !!}</span>
                        </div>
                        <div class="row table-row-15">
                            <span>
                                {!! $item->class_structure_program ?
                                $item->class_structure_program->structure_program->class_occupation->name: '--' !!}
                            </span>
                        </div>
                        <div class="row table-row-15">
                            <span>
                                {!! $item->staff->full_name !!}
                            </span>
                        </div>
                        <div class="row table-row-25">
                            <span>
                                {!! $item->shift->name !!}
                            </span>
                        </div>
                        <div class="row table-row-15">
                            <span>
                                {!! $item->class_level->name !!}
                            </span>
                        </div>
                        <div class="row table-row-20">
                            <span>
                                {!! $item->class_level->name !!}
                            </span>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
            <div class="row">
                <div class="form-row">
                    <label for="classes">Please select one class to assign<span>*</span></label>
                    <select id="classes" name="class_id">
                        <option value="">Please select class to assign</option>
                        @foreach($classes as $class)
                        <option value="{!! $class->id !!}">
                            [Class ID: {!! $class->id !!}]
                            [{!! $class->shift->name !!}]
                            [{!! $class->class_status->name !!}]
                            [{!! $class->class_level->name !!}]
                            [{!! $class->class_type->name !!}]
                            [{!! $class->generation !!}]
                            [{!! $class->group !!}]
                        </option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="form-button">
                <button type="submit" color="primary">
                    <i data-feather="save"></i>
                    <span>Submit</span>
                </button>
                <button color="danger" type="button" s-click-link="{!! route('admin-student-list', 1) !!}">
                    <i data-feather="x"></i>
                    <span>Cancel</span>
                </button>
            </div>
        </div>
        <div class="form-footer"></div>
    </form>
</div>
@include('admin::file-manager.popup')
@stop

@section('script')
<script>
    $(document).ready(function() {
            $("#date").datepicker({
                changeYear: true,
                dateFormat: "yy-mm-dd",
            });
        });
</script>
<script lang="ts">
    $(document).ready(function() {
            $validator("#form", {
                name: {
                    required: true,
                },
                phone: {
                    required: true,
                },
                phone_with_telegram: {
                    required: true,
                },
                gender: {
                    required: true,
                },
                dob: {
                    required: true,
                },
                email: {
                    required: true,
                },
                id_card: {
                    required: true,
                },
                address: {
                    required: true,
                },
            });
        });
        function selectImage(e) {
            fileManager({
                multiple: false,
                afterClose: (data, basePath) => {
                    if (data?.length > 0) {
                        const parent = e.target.closest('.form-select-photo');
                        e.target.value = data[0].path;
                        parent
                            .querySelector('.select-photo')
                            .classList.add('active');
                        parent
                            .querySelector('.image-view')
                            .classList
                            .add('active');
                        parent
                            .querySelector('.image-view')
                            .childNodes[0]
                            .nextElementSibling
                            .setAttribute('src', basePath + data[0].path);
                    }
                }
            })
        }
</script>
@stop