@extends('admin::shared.layout')
@section('layout')
    <div class="form-admin">
        <div class="form-bg"></div>
        <form id="form" class="form-wrapper" action="{!! route('admin-student-save', request('id')) !!}" method="POST" enctype="multipart/form-data">
            <div class="form-header">
                <h3>
                    <i data-feather="arrow-left" s-click-link="{!! route('admin-student-list', 1) !!}"></i>
                    {!! request('id') ?'Update Student':'Create Student' !!}
                </h3>
            </div>
            {{ csrf_field() }}
            <div class="form-body">
                <div class="row">
                    <div class="form-row">
                        <label>Education Level <span>*</span></label>
                        <select name="education_level_id">
                            @foreach($education_level as $value)
                                <option value="{!!$value->id!!}">{!!$value->name!!}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="row-2">
                    <div class="form-row">
                        <label>Full Name (Latin)<span>*</span> </label>
                        <input type="text" name="name_latin" value="{!! request('id') ? $data->name_latin : old('name_latin') !!}"
                               placeholder="Student full name (latin)">
                    </div>
                    <div class="form-row">
                        <label>Full Name (Khmer)<span>*</span></label>
                        <input type="text" name="name_khmer" value="{!! request('id') ? $data->name_khmer : old('name_khmer') !!}" placeholder="Student full name (khmer)" autocomplete="off">
                        @error('name_khmer')
                            <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                </div>
                <div class="row-2">
                    <div class="form-row">
                        <label>Phone Number with Telegram</label>
                        <input type="text" name="phone_with_telegram" value="{!! request('id') ? $data->phone_with_telegram : old('phone_with_telegram') !!}" placeholder="`Phone number with Telegram Account" autocomplete="off">
                        @error('phone_with_telegram')
                        <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                    <div class="form-row">
                        <label>Phone<span>*</span> </label>
                        <input type="text" name="phone" value="{!! request('id') ? $data->phone : old('phone') !!}" data-old="{!! request('id') ? $data->phone : old('phone') !!}"
                               placeholder="Enter Phone" autocomplete="off">
                        @error('phone')
                        <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                </div>
                <div class="row-2">
                    <div class="form-row">
                        <label>Gender<span>*</span> </label>
                        <select name="gender">
                            <option value="F" {!! (request('id') && $data->gender == "F") ? 'selected' : '' !!}>Female</option>
                            <option value="M" {!! (request('id') && $data->gender == "M") ? 'selected' : '' !!}>Male</option>
                        </select>
                    </div>
                    <div class="form-row">
                        <label>Date of bird<span>*</span></label>
                        <input type="date" name="dob" value="{!! request('id') ? $data->dob : old('dob') !!}" placeholder="" autocomplete="off">
                        @error('dob')
                        <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                </div>
                <div class="row-2">
                    <div class="form-row">
                        <label>ID Card</label>
                        <input type="text" name="id_card" value="{!! request('id') ? $data->id_card : old('id_card') !!}" placeholder="Identity Card Number" autocomplete="off">
                        @error('id_card')
                        <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                    <div class="form-row">
                        <label>Student ID<span>*</span> </label>
                        <input type="sid" name="sid" value="{!! request('id') ? $data->sid : old('sid') !!}" placeholder="Student ID" autocomplete="off">
                        @error('sid')
                        <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                </div>
                <div class="row">
                    <div class="form-row">
                        <label>Email</label>
                        <input type="email" name="email" value="{!! request('id') ? $data->email : old('email') !!}" placeholder="Student email" autocomplete="off">
                        @error('email')
                        <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                </div>
                <div class="row">
                    <div class="form-row">
                        <label>Noted</label>
                        <textarea name="noted" placeholder="">{!! request('id') ? $data->noted : old('noted') !!}</textarea>
                        @error('noted')
                        <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                </div>
                <div class="row">
                    <div class="form-row">
                        <label>Address (Khmer)<span>*</span> </label>
                        <textarea name="address_khmer" placeholder="អាស័យដ្ឋានបច្ចុប្បន្នជាខ្មែរ">{!! request('id') ? $data->address_khmer : old('address_khmer') !!}</textarea>
                        @error('address_khmer')
                        <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                </div>
                <div class="row">
                    <div class="form-row">
                        <label>Address (Latin)</label>
                        <textarea name="address_latin" placeholder="អាស័យដ្ឋានបច្ចុប្បន្នជាឡាតាំង">{!! request('id') ? $data->address_latin : old('address_latin') !!}</textarea>
                        @error('address_latin')
                            <span class="error">{!! $message !!}</span>
                        @enderror
                    </div>
                </div>
                <div class="row-2">
                    <div class="form-row">
                        <label>@lang('user.form.profile.label')</label>
                        <div class="form-select-photo image">
                            <div class="select-photo {!! request('id') && isset($data) && $data->profile != null ? 'active' : '' !!}">
                                <div class="icon">
                                    <i data-feather="image"></i>
                                </div>
                                <div class="title">
                                    <span>@lang('user.form.profile.placeholder')</span>
                                </div>
                            </div>
                            <div class="image-view {!! request('id') && isset($data) && $data->profile != null ? 'active' : '' !!}" >
                                <img src="{!! request('id') && isset($data) && $data->profile != null ? asset('file_manager' . $data->profile) : null !!}"  onerror="(this).src='{{ asset('images/logo/default.png') }}'" alt="">
                            </div>
                            <input type="text" name="image" s-click-fn="selectImage(event)" autocomplete="off"
                                role="presentation">
                            <input type="hidden" name="tmp_file" value="{!! request('id') && isset($data) && $data->profile != null ? $data->profile : '' !!}">
                        </div>
                    </div>
                </div>
                <div class="form-button">
                    <button type="submit" color="primary">
                        <i data-feather="save"></i>
                        <span>@lang('user.form.button.submit')</span>
                    </button>
                    <button color="danger" type="button" s-click-link="{!! route('admin-student-list', 1) !!}">
                        <i data-feather="x"></i>
                        <span>@lang('user.form.button.cancel')</span>
                    </button>
                </div>
            </div>
            <div class="form-footer"></div>
        </form>
    </div>
    @include('admin::file-manager.popup')
@stop

@section('script')
<script>
    $(document).ready(function() {
      $("#date").datepicker({
          changeYear: true,
          dateFormat: "yy-mm-dd",
      });
  });
</script>
    <script lang="ts">
         $(document).ready(function() {
            $validator("#form", {
                name_latin: {
                    required: true,
                },
                name_khmer: {
                    required: true,
                },
                phone: {
                    required: true,
                },
                gender: {
                    required: true,
                },
                dob: {
                    required: true,
                },
                sid: {
                    required: true,
                },
                address_khmer: {
                    required: true,
                },
            });
        });
        function selectImage(e) {
            fileManager({
                multiple: false,
                afterClose: (data, basePath) => {
                    if (data?.length > 0) {
                        const parent = e.target.closest('.form-select-photo');
                        e.target.value = data[0].path;
                        parent
                            .querySelector('.select-photo')
                            .classList.add('active');
                        parent
                            .querySelector('.image-view')
                            .classList
                            .add('active');
                        parent
                            .querySelector('.image-view')
                            .childNodes[0]
                            .nextElementSibling
                            .setAttribute('src', basePath + data[0].path);
                    }
                }
            })
        }
    </script>
@stop
