@extends('admin::shared.layout')
@section('layout')
    <div class="form-admin">
        <div class="form-bg"></div>
        <form id="form" class="form-wrapper" action="{!! route('admin-study-score-save', request('id')) !!}"
              method="POST" enctype="multipart/form-data">
            <div class="form-header">
                <h3>
                    <i data-feather="arrow-left" s-click-link="{!! route('admin-study-score-list', 1) !!}"></i>

                    {!! request('id') ? 'Update Competency Type' : 'Create New Competency Type' !!}
                </h3>
            </div>
            {{ csrf_field() }}
            <div class="form-body">
                <div class="row-2">
                    <div class="form-row">
                        <label>Generic<span>*</span> </label>
                        <input type="number" name="generic_score"
                               value="{!! request('id') ? $data->generic_score : old('generic_score') !!}"
                               placeholder="Generic Score">
                    </div>
                    <div class="form-row">
                        <label>Functional<span>*</span> </label>
                        <input type="text" name="functional_score"
                               value="{!! request('id') ? $data->functional_score : old('functional_score') !!}"
                               placeholder="Functional Score">
                    </div>
                </div>
                <div clas="row">
                      <div class="form-row">
                        <label>Competency<span>*</span> </label>
                        <input type="text" name="competency"
                               value="{!! request('id') ? $data->competency : old('competency') !!}"
                               placeholder="Competency">
                    </div>
                </div>
                <div class="form-button">
                    <button type="submit" color="primary">
                        <i data-feather="save"></i>
                        <span>@lang('user.form.button.submit')</span>
                    </button>
                    <button color="danger" type="button" s-click-link="{!! route('admin-study-score-list', 1) !!}">
                        <i data-feather="x"></i>
                        <span>@lang('user.form.button.cancel')</span>
                    </button>
                </div>
            </div>
            <div class="form-footer"></div>
        </form>
    </div>
    @include('admin::file-manager.popup')
@stop

@section('script')

    <script lang="ts">
        $(document).ready(function () {
            $validator("#form", {
                generic_score: {
                    required: true,
                },
                functional_score: {
                    required: true,
                },
                competency:{
                     required: true,
                    
                }
            });
        });
    </script>
@stop
