<?php

use Carbon\Carbon;
use Illuminate\Support\MessageBag;
use Illuminate\Support\Facades\Gate;

function customUrl($url, $queryParam)
{
    $pattern = "/\?/i";
    $query = "";
    $i = 0;
    $parseUrl = parse_url($url, PHP_URL_QUERY);
    parse_str($parseUrl, $params);
    foreach (collect($queryParam) as $key => $value) {
        if (!isset($params[$key])) {
            if ($i == 0) {
                $hasQuery = preg_match($pattern, $url);
                if ($hasQuery < 1) {
                    $query .= '?' . $key . '=' . $value;
                } else {
                    $query .= '&' . $key . '=' . $value;
                }
            } else {
                $query .= '&' . $key . '=' . $value;
            }
        }
        $i++;
    }
    return $url ? $url . $query : '';
}

function routeActive(string $route)
{
    $arr = explode(',', $route);
    foreach ($arr as $item) {
        if (request()->is($item)) {
            return true;
        }
    }
    return false;
}

function resData($data = null)
{
    return response()->json([
        'data' => $data,
        'message' => 'fetch_data_success',
        'error' => false,
    ], 200);
}

function resSuccess($message, $data = null, array $options = [])
{
    return response()->json([
        'message' => $message,
        'error' => false,
        'data' => $data,
        ...$options,
    ], 200);
}

function resFail($message, Exception $exception = null)
{
    $response = [
        'message' => $message,
        'error' => true,
    ];
    if ($exception) {
        $response['exception'] = [
            'message' => $exception->getMessage(),
            'file' => $exception->getFile(),
            'line' => $exception->getLine(),
        ];
    }
    return response()->json($response, 202);
}

function resValidate(MessageBag $message)
{
    $response = [
        'validate' => $message,
        'error' => true,
    ];
    return response()->json($response, 422);
}
function CheckRole($field)
{
    return Gate::check($field) ? true : false;
}
function createFormat($date, $format = null)
{
    if ($date == "currentDate") {
        return Carbon::now()->format($format);
    }
    return $date->format('Y-m-d');
}

function calcTime($data, $type)
{
    $conclusion = null;
    $totalHour  = 0; 
    $minute  = 0;
    $totalMinute = 0;
    $convertMnToHour = 0;
    if($type == 'practice'){
        foreach($data as $item){
            if($item->practice_duration_type == 'h'){
                $totalHour += $item->practice_hour;
            }else{
                $totalMinute += $item->practice_hour;
            }
        }
    }else{
        foreach($data as $item){
            if($item->theory_duration_type == 'h'){
                $totalHour += $item->theory_hour;
            }else{
                $totalMinute += $item->theory_hour;
            }
        }
    }
    if($totalMinute >= 60){
        $convertMnToHour = floor($totalMinute / 60);
        $minute = ($totalMinute % 60);
        $totalHour += $convertMnToHour;
    }
    if($totalHour > 0){
        $conclusion = $totalHour . 'h ';
    }
    if($minute > 0 && $totalMinute >=60){
        $conclusion .= $minute . 'mn';
    }else{
        $conclusion .= $totalMinute . 'mn';
    }
    return $conclusion;
}

function calcStudyDay($data, $type){
    $totalDay = 0;
    $totalHour = 0; 
    $totalMinute = 0;
    if($type == 'practice'){
        foreach($data as $item){
            if($item->practice_duration_type == 'h'){
                $totalHour += $item->practice_hour;
            }else{
                $totalMinute += $item->practice_hour;
            }
        }
    }else{
        foreach($data as $item){
            if($item->theory_duration_type == 'h'){
                $totalHour += $item->theory_hour;
            }else{
                $totalMinute += $item->theory_hour;
            }
        }
    }
    if($totalMinute >= 60){
        $convertMnToHour = floor($totalMinute / 60); 
        $totalHour += $convertMnToHour;
    }
    $totalDay = round($totalHour / 3);
    if($totalDay < 1){
        $totalDay = 1;
    }
    return $totalDay;
}