<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\AboutChild;
use App\Models\About;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;

class AboutChildCotroller extends Controller
{
    protected $layout = 'admin::pages.about.child.';
    function __construct()
    {
        $this->middleware('permission:about-child-view', ['only' => ['index']]);
        $this->middleware('permission:about-child-create', ['only' => ['onCreate', 'onSave']]);
        $this->middleware('permission:about-child-update', ['only' => ['onCreate', 'onSave', 'onUpdateStatus']]);
    }
    public function index(Request $req)
    {
        if (!$req->id) {
            return redirect()->route('admin-about-child-list', 1);
        }
        $data['data'] = AboutChild::when(filled(request('search')), function ($q) {
            $q->where(function ($q) {
                $q->where('title', 'like', '%' . request('search') . '%');
            });
        })
            ->where('status', $req->id)
            ->orderByDesc("id")
            ->paginate(50);
        return view($this->layout . 'index', $data);
    }
    public function onCreate(Request $req)
    {
        if ($req->id) {
            $data['data'] = AboutChild::find($req->id);
            return view($this->layout . 'create', $data);
        } else {
            return view($this->layout . 'create');
        }
    }
    public function onSave(Request $req)
    {
        $id = $req->id;
        $data = About::first();
        if ($data) {
            $req->validate(
                [
                    'title' => 'required',
                    'description' => 'required',
                ],
                [
                    'title.required' => 'field is require',
                    'description.required' => 'field is require',
                ]
            );
            $items = [
                'title' => $req->title,
                'description' => $req->description,
                'image' => $req->image ?? $req->tmp_file ?? null,
                'status' => $req->status ?? 1,
                'about_id' => $data->id,
            ];
            DB::beginTransaction();
            try {
                if ($id) {
                    AboutChild::findOrFail($id)->update($items);
                    $status = "Update success.";
                } else {
                    AboutChild::create($items);
                    $status = "Create success";
                }
                DB::commit();
                Session::flash('success', $status);
                return redirect()->route('admin-about-child-list', 1);
            } catch (\Exception $e) {
                dd($e);
                DB::rollback();
                Session::flash('warning', 'Create unsuccess!');
                return redirect()->back();
            }
        } else {
            Session::flash('warning', 'Create About Data First!');
            return redirect()->back();
        }
    }

    public function onUpdateStatus(Request $req)
    {
        $status = true;
        $item = [
            "status" => $req->status,
        ];
        DB::beginTransaction();
        try {
            $status = $req->status == 2 ? "Disable successful!" : "Enable successful!";
            AboutChild::where("id", $req->id)->update($item);
            DB::commit();
            Session::flash("success", $status);
        } catch (\Exception $error) {
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
        }
        return redirect()->back();
    }
}
