<?php

namespace App\Http\Controllers\Admin;


use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Models\Classes;
use App\Models\Lesson;
use App\Models\Attendance;
use App\Models\AttendanceStatus;
use App\Http\Controllers\Controller;
use App\Models\LessonOccupation;

class AttendanceStatusController extends Controller
{

    // calc class's lesson hour to day
    public function calcClassDuration(int $class_id)
    {
        $lesson_id = Classes::find(3)->class_structure_program->structure_program->lesson_id;
        $lessons = Lesson::whereIn('id', $lesson_id)->get();

        $lesson_hour = 0;
        foreach ($lessons as $lesson) {
            $lesson_hour += $lesson->practice_hour;
        }
        $formula = round($lesson_hour / 3);
        return $formula;
    }

    // use to calc student attendance paste or not
    public function setIsAttendancePaste(int $class_id): void
    {
        $data['data'] = Attendance::where('class_id', $class_id)->get();
        $data['count'] = count($data['data']);
        $data['student'] = Classes::find($class_id)->students()->get();

        $count = 0;
        $day_attend = $this->calcClassDuration($class_id);
        foreach ($data['student'] as $student) {
            foreach ($data['data'] as $attend) {
                if (in_array($student->id, $attend->student_id)) {
                    $count += 1;
                }
            }
            AttendanceStatus::updateOrCreate(
                [
                    'student_id' => $student->id,
                    'class_id' => $class_id,
                ],
                [
                    'student' => $student->id,
                    'class_id' => $class_id,
                    'attend_amount' => $count,
                    'today_attended' => 0,
                    'attend_percent' => (float)(round(($count / $day_attend) * 100) . '.00'),
                    'attend_status' => round(($count / $day_attend) * 100) > 49 ? 1 : 0,
                ]
            );
            $count = 0;
        }
    }

    // get attendance status data
    public function getIsAttendancePaste(int $class_id)
    {
        $data = AttendanceStatus::where('class_id', $class_id)->get();
        return $data;
    }
}
