<?php

namespace App\Http\Controllers\Admin;
use App\Models\Branch;
use App\Models\BranchCode;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use Exception;

class BranchController extends Controller
{
    protected $layout = 'admin::pages.branch.';
    public function __construct()
    {
        parent::__construct();
        $this->middleware('permission:branch-view', ['only' => ['index']]);
        $this->middleware('permission:branch-create', ['only' => ['onCreate', 'onSave']]);
        $this->middleware('permission:branch-update', ['only' => ['onCreate', 'onSave', 'onUpdateStatus']]);
    }
    public function index(Request $req, $id = 1, $referent = null)
    {
        if (!$req->id) {
            return redirect()->route('admin-branch-list', 1);
        }
        $data["referent"] = $referent;
            $refer = null;
            if ($req->referent) {
                $split = explode('/', $referent);
                $split = array_diff($split, array("", null));
                $data["refer"] = $split;
                // return $split;
                $data["refer_list"] = Branch::with('branch_code')
                    ->whereHas('branch_code', function ($query) use ($split) {
                        $query->whereIn("code", $split);
                    })->get();
                // return $data['refer_list'];
                $refer = end($split);
            }
            $data['data'] = Branch::with('branch_code')
                ->whereHas('branch_code', function ($query) use ($refer) {
                    $query->when(filled($refer), function ($q) use ($refer) {
                        $q->where('parent_code', 'like', '%' . "$refer" . '%');
                    });
                })
                ->when(filled(request('keyword')), function ($q) {
                    $q->where(function ($query) {
                      $query->where('name', 'like', '%' . request('keyword') . '%');
                    })->orWhereHas('branch_code', function ($query) {
                        $query->where('code', 'like', '%' . request('keyword') . '%');
                    });
                })
                ->when($this->userBranch, function ($q) {
                    $q->whereId($this->userBranch->id)
                        ->whereUserId(auth()->user()->id);
                })
                ->where('status', $req->id)
                ->orderByDesc("created_at")
                ->paginate(50);
        return view($this->layout.'index', $data);
    }

    public function onCreate(Request $req)
    {
        $data['branches'] = Branch::where('status',1)->get();
        if($req->id){
            $data["data"] = Branch::findOrFail($req->id);
            $data['branches'] = Branch::where('id', '!=', $data['data']->id)->where('status',1)->get();
            return view($this->layout.'create', $data);
        }
        return view($this->layout.'create', $data);
    }

    public function onSave(Request $req)
    {
        $id = $req->id;
        $item = [
            'name' => $req->name,
            'address' => $req->address,
            'phone' => $req->phone,
            'email' => $req->email,
            'logo' => $req->image ?? $req->tmp_file ?? null,
            'website' => $req->website,
            'working_day' => $req->working_day,
            'working_hour' => $req->working_hour,
            'status' => $req->status ?? 1,
            'is_default' => 0,
            'user_id' => auth()->user()->id,
        ];
        $validator = Validator::make(
            $req->all(),[
            "name" => "required|unique:lessons,name" . ($id ? ",$id" : ''),
            "address" => 'required',
            "phone" => 'required',
        ], [
            "name.unique" => "Name already exist",
            "name.required" => 'Value is required',
            "address.required" => 'Value is required',
            "phone.required" => 'Value is required',
        ]);
        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }
        $status = "Create success.";
        DB::beginTransaction();
        try {
            $code = BranchCode::where('branch_id', $req->parent_id)->first();
            if (!$id) {
                $branch = Branch::create($item);
                BranchCode::create([
                    "branch_id" => $branch->id,
                    "code" => "BC00".$branch->id,
                    "parent_code" => $code->code ?? null,
                    "parent_id" => $code->branch_id ?? null,
                ]);
            } else {
                $branch = Branch::find($id);
                $branch->update($item);
                BranchCode::where('branch_id', $branch->id)->update([
                    "parent_code" => $code->code ?? null,
                    "parent_id" => $code->branch_id ?? null,
                ]);
                $status = "Update success.";
            }
            DB::commit();
            Session::flash("success", $status);
            return redirect()->route("admin-branch-list", 1);
        } catch (Exception $error) {
            DB::rollback();
            return $error;
            Session::flash('warning', 'Create unsuccess!');
            return redirect()->back();
        }
    }

    public function onUpdateStatus(Request $req)
    {
        $status = true;
        $item = [
            "status" => $req->status,
        ];
        DB::beginTransaction();
        try {
            $status = $req->status == 2 ? "Disable successful!" : "Enable successful!";
            Branch::where("id", $req->id)->update($item);
            DB::commit();
            Session::flash("success", $status);
        } catch (Exception $error) {
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
        }
        return redirect()->back();
    }
}
