<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Contact;
use App\Models\Cover;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;

class ContactController extends Controller
{
    protected $layout = 'admin::pages.contact.';
    function __construct()
    {
        $this->middleware('permission:contact-view', ['only' => ['onCreate', 'onSave', 'onSaveCover']]);
    }
    public function onCreate()
    {
        $data['data'] = Contact::where('status', 1)->first();
        return view($this->layout . 'create', $data);
    }
    public function onSave(Request $req)
    {
        // $data = Contact::first();
        $req->validate(
            [
                'phone' => 'required',
                'email' => 'required',
                'address' => 'required',
                'name' => 'required',
            ],
            [
                'phone.required' => 'field is require',
                'email.required' => 'field is require',
                'address.required' => 'field is require',
                'name.required' => 'field is require',
            ]
        );
        $items = [
            'phone' => $req->phone,
            'email' => $req->email,
            'address' => $req->address,
            'name' => $req->name,
            'facebook' => $req->facebook,
            'instagram' => $req->instagram,
            'youtube' => $req->youtube,
            'telegram' => $req->telegram,
            'google_map' => $req->google_map,
            'status' => 1,
        ];
        DB::beginTransaction();
        try {
            Contact::updateOrCreate(
                [
                    'status' => 1
                ],
                $items
            );
            $status = "Update success.";
            DB::commit();
            Session::flash('success', $status);
            return redirect()->back();
        } catch (\Exception $e) {
            dd($e);
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
            return redirect()->back();
        }
    }
    public function onCreateCover()
    {
        $data['data'] = Cover::where('type', 'home')->first();
        return view($this->layout . 'cover', $data);
    }
}