<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Cover;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;

class CoverController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:about-view', ['only' => ['onCreate', 'onSave']]);
    }
    public function onSave(Request $req)
    {
        // $data = Cover::first();
        $req->validate(
            [
                'image' => 'required',
            ],
            [
                'image.required' => 'field is require',
            ]
        );
        $items = [
            'type' => $req->type,
            'image' => $req->image ?? $req->tmp_file,
        ];
        DB::beginTransaction();
        try {
            if ($req->type == 'about') {
                Cover::updateOrCreate(
                    [
                        'type' => 'about'
                    ],
                    $items
                );
            }
            if ($req->type == 'home') {
                Cover::updateOrCreate(
                    [
                        'type' => 'home'
                    ],
                    $items
                );
            }
            $status = "Update success.";
            DB::commit();
            Session::flash('success', $status);
            return redirect()->back();
        } catch (\Exception $e) {
            dd($e);
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
            return redirect()->back();
        }
    }
}
