<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ExamCandidate;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;


class ExamCandidateController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:exam-candidate-view', ['only' => ['index']]);
        $this->middleware('permission:exam-candidate-assign', ['only' => ['onAssign']]);
        $this->middleware('permission:exam-candidate-unassign', ['only' => ['onUnassign']]);
        $this->middleware('permission:exam-candidate-print', ['only' => ['onPrint']]);
    }
    public function onAssign(Request $req)
    {
        $item = [
            'class_id' => $req->class_id,
            'exam_id' => $req->exam_id,
            'student_id' => $req->student_id,
        ];

        DB::beginTransaction();
        try {
            ExamCandidate::create($item);
            DB::commit();
            return response()->json([
                'code' => 20000,
                'message' => 'Assigned success.',
            ]);
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json([
                'code' => 40005,
                'message' => 'Assigned unsuccess!',
            ]);
        }
    }

    public function onUnassign(Request $req)
    {
        $data = ExamCandidate::where('class_id', $req->class_id)->where('exam_id', $req->exam_id)->where('student_id', $req->student_id)->first();
        DB::beginTransaction();
        try {
            $data->delete();
            DB::commit();
            return response()->json([
                'code' => 20000,
                'message' => 'Unsssigned success.',
            ]);
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json([
                'code' => 40005,
                'message' => 'Unassigned unsuccess!',
            ]);
        }
    }

    public function index()
    {
        $data = ExamCandidate::with('student')->where('class_id', request('class_id'))->where('exam_id', request('exam_id'))->get();

        return response()->json($data);
    }
}
