<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Classes;
use App\Models\Student;
use Illuminate\Support\Facades\Session;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Group;
use Exception;

class GroupController extends Controller
{
    protected $layout = 'admin::pages.group.';
    public function __construct()
    {
        $this->middleware('permission:group-view', ['only' => ['index']]);
        $this->middleware('permission:group-create', ['only' => ['onSave']]);
        $this->middleware('permission:group-destroy', ['only' => ['onDelete']]);
        $this->middleware('permission:group-view-info', ['only' => ['studentInGroup']]);
        $this->middleware('permission:group-assign', ['only' => ['onAssign']]);
        $this->middleware('permission:group-unassign', ['only' => ['onUnassign']]);
    }
    public function index()
    {
        $data['data'] = Group::where('class_id', request('class_id'))->with('students')->get();
        return view($this->layout . 'index', $data);
    }
    public function onSave(Request $req)
    {
        $class = Classes::find($req->class_id);
        DB::beginTransaction();
        try {
            if ($class->whereIn('class_status_id', [1, 2])) {
                Group::create([
                    'class_id' => $req->class_id,
                    'name' => $req->name,
                ]);
                DB::commit();
                Session::flash("success", "Created success.");
                return redirect()->back();
            }
        } catch (Exception $e) {
            DB::rollBack();
            Session::flash("warning", "Created unsuccess!");
            return redirect()->back();
        }
    }
    public function onDelete(Request $req)
    {
        $data = Group::findOrFail($req->group_id);
        DB::beginTransaction();
        try {
            foreach ($data->students as $item) {
                $data->students()->detach($item->id);
            }
            $data->delete();
            DB::commit();
            Session::flash("success", "Deleted success.");
            return redirect()->back();
        } catch (Exception $e) {
            DB::rollBack();
            Session::flash("warning", "Deleted unsuccess");
            return redirect()->back();
        }
    }
    public function onAssign(Request $req)
    {
        $group = Group::findOrFail($req->group_id);
        DB::beginTransaction();
        try {
            $group->students()->attach($req->student_id);
            DB::commit();
            return response()->json([
                'code' => 20000,
                'message' => 'Assigned success.',
            ]);
        } catch (Exception $e) {
            DB::rollBack();
            return response()->json([
                'code' => 40005,
                'message' => 'Assigned unsuccess!',
            ]);
        }
    }
    public function onUnassign(Request $req)
    {
        $group = Group::findOrFail($req->group_id);
        DB::beginTransaction();
        try {
            $group->students()->detach($req->student_id);
            DB::commit();
            return response()->json([
                'code' => 20000,
                'message' => 'Unassigned success.',
            ]);
        } catch (Exception $e) {
            DB::rollBack();
            return response()->json([
                'code' => 40005,
                'message' => 'Unassigned unsuccess!',
            ]);
        }
    }


    public function studentCondition()
    {
        $data = Classes::findOrFail(request('class_id'))->students()->with('groups')->get();
        return response()->json($data);
    }
    public function studentInGroup()
    {
        $data = Group::findOrFail(request('group_id'))->students()->get();
        return response()->json($data);
    }
}
