<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Partner;
use App\Models\Slide;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;

class PartnerController extends Controller
{
    protected $layout = 'admin::pages.partner.';
    function __construct()
    {
        $this->middleware('permission:partner-view', ['only' => ['index']]);
        $this->middleware('permission:partner-create', ['only' => ['onCreate', 'onSave']]);
        $this->middleware('permission:partner-update', ['only' => ['onCreate', 'onSave', 'onUpdateStatus']]);
    }
    public function index(Request $req)
    {
        if (!$req->id) {
            return redirect()->route('admin-partner-list', 1);
        }
        $data['data'] = Partner::when(filled(request('search')), function ($q) {
            $q->where(function ($q) {
                $q->where('name', 'like', '%' . request('search') . '%');
            });
        })
            ->where('status', $req->id)
            ->orderByDesc("id")
            ->paginate(50);
        return view($this->layout . 'index', $data);
    }
    public function onCreate(Request $req)
    {
        if ($req->id) {
            $data['data'] = Partner::find($req->id);
            return view($this->layout . 'create', $data);
        } else {
            return view($this->layout . 'create');
        }
    }
    public function onSave(Request $req)
    {
        $id = $req->id;
        $req->validate(
            [
                'name' => 'required',
                'phone' => 'required',
                'address' => 'required',
            ],
            [
                'name.required' => 'field is require',
                'phone.required' => 'field is require',
                'address.required' => 'field is require',
            ]
        );
        $items = [
            'name' => $req->name,
            'image' => $req->image ?? $req->tpp_file ?? null,
            'phone' => $req->phone,
            'facebook' => $req->facebook,
            'address' => $req->address,
            'google_map' => $req->google_map,
            'status' => $req->status ?? 1,
            'international' => $req->international ? 1 : 0,
        ];
        DB::beginTransaction();
        try {
            if ($id) {
                Partner::findOrFail($id)->update($items);
                $status = "Update success.";
            } else {
                Partner::create($items);
                $status = "Create success";
            }
            DB::commit();
            Session::flash('success', $status);
            return redirect()->route('admin-partner-list', 1);
        } catch (\Exception $e) {
            dd($e);
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
            return redirect()->back();
        }
    }

    public function onUpdateStatus(Request $req)
    {
        $status = true;
        $item = [
            "status" => $req->status,
        ];
        DB::beginTransaction();
        try {
            $status = $req->status == 2 ? "Disable successful!" : "Enable successful!";
            Partner::where("id", $req->id)->update($item);
            DB::commit();
            Session::flash("success", $status);
        } catch (\Exception $error) {
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
        }
        return redirect()->back();
    }
    public function slide(Request $req)
    {
        if (!$req->id) {
            return redirect()->route('admin-slide-list', 1);
        }
        $data['data'] = Slide::when(filled(request('search')), function ($q) {
            $q->where(function ($q) {
                $q->where('name', 'like', '%' . request('search') . '%');
            });
        })
            ->where('status', $req->id)
            ->where('type', 'partner')
            ->orderByDesc("id")
            ->paginate(50);
        return view($this->layout . 'slide.index', $data);
    }

    public function onCreateSlide(Request $req)
    {
        if ($req->id) {
            $data['data'] = Slide::where(['id' => $req->id, 'type' => 'partner'])->first();
            return view($this->layout . 'create', $data);
        } else {
            return view($this->layout . 'slide.create');
        }
    }
}
