<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Attendance;
use App\Models\Classes;
use App\Models\Student;
use App\Models\Lesson;
use App\Models\StudentScore;
use App\Models\ExamCandidate;
use App\Models\Group;
use Carbon\Carbon;
use Illuminate\Support\Facades\Session;
use Illuminate\Http\Request;
use Exception;

class PrintingController extends Controller
{
    protected $layout = 'admin::pages.printing.';
    public function student()
    {
        if (!request('student_id') || !request('id')) {
            Session::flash("warning", "Invalided value");
            return redirect()->back();
        }
        $data['data'] = Student::whereIn('id', request('student_id'))->get();
        $data['class'] = Classes::find(request('id'));
        $data['all_student'] = Classes::find(request('id'))->students()->get();
        $data['count'] = count($data['all_student']);
        $data['count_F'] = count($data['all_student']->where('gender', 'F'));
        return view($this->layout . 'student.printing-student', $data);
    }

    // should use try
    public function attendance()
    {
        try {
            // fetch data from class and its attendance
            $data['data'] = Classes::findOrFail(request('id'));
            $data['attendance'] = Attendance::where('class_id', request('id'))->get();
            // count/sum student and attendance
            $data['count'] = count($data['data']->students);
            $data['count_F'] = count($data['data']->students->where('gender', 'F'));
            $data['total_attendance'] = (new AttendanceStatusController)->calcClassDuration(request('id'));
            // create collection of students and their attendance in each class
            $data['students'] = [];
            $count = 0;
            $student_attendance = [];
            foreach ($data['data']->students as $value) {
                $data['students'][$value->id] = $value;
                foreach ($data['attendance'] as $item) {
                    if (in_array($value->id, $item->student_id)) {
                        $count += 1;
                        $student_attendance[] = $item;
                    }
                }
                $data['students'][$value->id]['attendances'] = $student_attendance;
                $data['students'][$value->id]['total_student_attendance'] = $count;
                $count = 0;
                $student_attendance = [];
            }
            return view($this->layout . 'attendance.printing-attendance', $data);
        } catch (Exception $e) {
            Session::flash('warning', 'Invalided Valued');
            return redirect()->back();
        }
    }

    public function attendanceDate()
    {
        try {
            if (!request('date')) {
                $date = Carbon::now()->format('Y-m-d');
            } else {
                $date = Carbon::create(request('date'))->format('Y-m-d');
            }
            // fetch data from class and its attendance
            $data['data'] = Classes::find(request('id'));
            $data['attendance'] = Attendance::where('class_id', request('id'))->whereDate('log_date', $date)->with('lessons')->get();
            // count/sum student and attendance
            $data['count'] = count($data['data']->students);
            $data['count_F'] = count($data['data']->students->where('gender', 'F'));
            $data['total_attendance'] = count($data['attendance']);
            
            return view($this->layout . 'attendance.printing-attendance-by-date', $data);
        } catch (Exception $e) {
            Session::flash('warning', 'Invalided Valued');
            return redirect()->back();
        }
    }
    public function studentScore(Request $req)
    {
        $data['data'] = StudentScore::where('class_id', $req->class_id)->orderBy('ranking')->get();
        $data['all_student'] = Classes::find($req->class_id)->students()->get();
        $data['count'] = count($data['all_student']);
        $data['count_F'] = count($data['all_student']->where('gender', 'F'));
        $data['class'] = Classes::find($req->class_id);
        $lesson_id = [];
        if ($data['class']->class_structure_program) {
            $lesson_id = $data['class']->class_structure_program->structure_program->lesson_id;
        }
        $data['lessons'] = Lesson::whereIn('id', $lesson_id)->get();
        $data['count_ss_F'] = 0;
        foreach ($data['data'] as $item) {
            if ($item->student->gender == 'F') {
                $data['count_ss_F'] += 1;
            }
        }
        return view($this->layout . 'student.student-score', $data);
    }

    public function examCandidate(Request $req)
    {
        $data['data'] = ExamCandidate::where(['exam_id' => $req->exam_id, 'class_id' => $req->class_id])->get();
        $data['class'] = Classes::find($req->class_id);
        $data['all_student'] = Classes::find($req->class_id)->students()->get();
        $data['count'] = count($data['all_student']);
        $data['count_F'] = count($data['all_student']->where('gender', 'F'));
        $data['count_ec_F'] = 0;
        foreach ($data['data'] as $item) {
            if ($item->student->gender == 'F') {
                $data['count_ec_F'] += 1;
            }
        }
        return view($this->layout . 'exam.exam-candidate', $data);
    }

    public function StudentGroup(Request $req)
    {
        $data['data'] = Group::where('class_id', $req->class_id)->get();
        $data['class'] = Classes::find($req->class_id);
        $data['all_student'] = Classes::find($req->class_id)->students()->get();
        $data['count'] = count($data['all_student']);
        $data['count_F'] = count($data['all_student']->where('gender', 'F'));

        return view($this->layout . 'student.student-group', $data);
    }
}
