<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ClassOccupation;
use App\Models\ClassStatus;
use App\Models\Lesson;
use App\Models\StructureProgram;
use App\Models\Classes;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Exception;
use App\Models\ClassStructureProgram;

Class ProgramClassController extends Controller
{
    protected $layout = 'admin::pages.programClass.';
    public function __construct()
    {
        parent::__construct();
        $this->middleware('permission:class-program-view', ['only' => ['index']]);
    }
    public function index(Request $req)
    {
        if (!$req->id) {
            return redirect()->route('admin-program-class-list', 1);
        }

        $data['classes'] = Classes::all();
        $data['class_statuses'] = ClassStatus::all();
        $data['structure_programs'] = StructureProgram::all();
        $data['lesson'] = Lesson::where('status', 1)->get();
        $data['class_occupations'] = ClassOccupation::where('status', 1)->get();
        $data['data'] = ClassStructureProgram::when(filled(request('keyword')), function ($q) {
            $q->where(function ($q) {
                    $q->where('each_generic_score', 'like', '%' . request('keyword') . '%')
                        ->orWhere('each_functional_score', 'like', '%' . request('keyword') . '%')
                        ->orWhere('id', 'like', '%' . request('keyword') . '%');
    
                });
            })
            ->when($this->userBranch, function ($q) {
                $q->whereHas('structure_program', function ($q) {
                    $q->whereHas('user', function ($q) {
                        $q->where('branch_id', $this->userBranch->id);
                    });
                });
            })
            ->orderByDesc("id")
            ->paginate(50);
        return view($this->layout.'index', $data);
    }
    public function onCreate(Request $req)
    {
        $data["data"] = ClassStructureProgram::find($req->id);
        $data['class'] = Classes::all();
        $data['structure_program'] = StructureProgram::all();
//        dd($data['structure_program']);
        return view($this->layout.'create', $data);
    }

    public function onSave(Request $req)
    {
        $id = $req->id;
        $item = [
            "generic_full_score" => $req->generic_full_score,
            "functional_full_score" => $req->functional_full_score,
            "generic_subject" => $req->generic_subject,
            "functional_subject" => $req->functional_subject,
            "each_generic_score" => $req->each_generic_score,
            "each_functional_score" => $req->each_functional_score,
        ];
//        $req->validate([
//            'class_id' => 'required',
//            'structure_program_id' => 'required',
//        ],[
//            'class_id.required' => "Please select one of those class",
//            'structure_program_id.required' => "Please select one of those structured program"
//        ]);
        $status = "Create success.";
        DB::beginTransaction();
        try {
            if (!$id) {
                ClassStructureProgram::create($item);
            } else {
                ClassStructureProgram::find($id)->update($item);
                $status = "Update success.";
            }
            DB::commit();
            Session::flash("success", $status);
            return redirect()->route("admin-program-class-list", 1);
        } catch (Exception $error) {
            dd($error);
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
            return redirect()->back();

        }
    }
}
