<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Question;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;

class QuestionController extends Controller
{
    protected $layout = 'admin::pages.question.';
    function __construct()
    {
        $this->middleware('permission:question-view', ['only' => ['index']]);
        $this->middleware('permission:question-create', ['only' => ['onCreate', 'onSave']]);
        $this->middleware('permission:question-update', ['only' => ['onCreate', 'onSave', 'onUpdateStatus']]);
    }
    public function index(Request $req)
    {
        if (!$req->id) {
            return redirect()->route('admin-question-list', 1);
        }
        $data['data'] = Question::when(filled(request('search')), function ($q) {
            $q->where(function ($q) {
                $q->where('question', 'like', '%' . request('search') . '%');
                $q->orWhere('answer', 'like', '%' . request('search') . '%');
            });
        })
            ->where('status', $req->id)
            ->orderByDesc("id")
            ->paginate(50);
        return view($this->layout . 'index', $data);
    }
    public function onCreate(Request $req)
    {
        if ($req->id) {
            $data['data'] = Question::find($req->id);
            return view($this->layout . 'create', $data);
        } else {
            return view($this->layout . 'create');
        }
    }
    public function onSave(Request $req)
    {
        $id = $req->id;
        $req->validate(
            [
                'question' => 'required',
                'answer' => 'required',
            ],
            [
                'question.required' => 'field is require',
                'answer.required' => 'field is require',
            ]
        );
        $items = [
            'question' => $req->question,
            'answer' => $req->answer,
            'status' => $req->status ?? 1,
        ];
        DB::beginTransaction();
        try {
            if ($id) {
                Question::findOrFail($id)->update($items);
                $status = "Update success.";
            } else {
                Question::create($items);
                $status = "Create success";
            }
            DB::commit();
            Session::flash('success', $status);
            return redirect()->route('admin-question-list', 1);
        } catch (\Exception $e) {
            dd($e);
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
            return redirect()->back();
        }
    }

    public function onUpdateStatus(Request $req)
    {
        $status = true;
        $item = [
            "status" => $req->status,
        ];
        DB::beginTransaction();
        try {
            $status = $req->status == 2 ? "Disable successful!" : "Enable successful!";
            Question::where("id", $req->id)->update($item);
            DB::commit();
            Session::flash("success", $status);
        } catch (\Exception $error) {
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
        }
        return redirect()->back();
    }
}