<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Attendance;
use App\Models\Student;
use App\Models\Classes;
use App\Models\ExamCandidate;
use App\Models\Lesson;
use Illuminate\Http\Request;

class SelectController extends Controller
{
    public function viewStudent()
    {
        $data = Student::with('classes')->findOrFail(request('id'));
        return response()->json($data);
    }

    public function attendance()
    {
        $data = Attendance::where('class_id', request('class_id'))->with('lessons')->get();
        return response()->json($data);
    }

    public function viewClass()
    {
        $data = Classes::with('attandance')->findOrFail(request('id'));
        return response()->json($data);
    }

    public function studentAttendanceAmount()
    {
        $data = Attendance::where('class_id', request('class_id'))->get();
        $count = 0;
        foreach ($data as $item) {
            if (in_array(request('student_id'), $item->student_id)) {
                $count += 1;
            }
        }
        return response()->json($count);
    }

    public function studentInClass()
    {
        if (request('class_id') && !request('exam_id')) {
            $data = Classes::findOrFail(request('class_id'))->students()->get();
        }
        if (request('class_id') && request('exam_id')) {
            $data = Classes::findOrFail(request('class_id'))->students()->whereHas('exam_candidates', function ($q) {
                $q->where('exam_id', request('exam_id'));
            })
                ->with('exam_candidates')
                ->get();
        }
        return response()->json($data);
    }
}
