<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Slide;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;

class SlideController extends Controller
{
    protected $layout = 'admin::pages.slide.';
    function __construct()
    {
        $this->middleware('permission:slide-view', ['only' => ['index']]);
        $this->middleware('permission:slide-create', ['only' => ['onCreate', 'onSave']]);
        $this->middleware('permission:slide-update', ['only' => ['onSave', 'onUpdateStatus']]);
    }
    public function index(Request $req)
    {
        if (!$req->id) {
            return redirect()->route('admin-slide-list', 1);
        }
        $data['data'] = Slide::when(filled(request('search')), function ($q) {
            $q->where(function ($q) {
                $q->where('name', 'like', '%' . request('search') . '%');
            });
        })
            ->where('status', $req->id)
            ->orderByDesc("id")
            ->paginate(50);
        return view($this->layout . 'index', $data);
    }
    public function onCreate(Request $req)
    {
        if ($req->id) {
            $data['data'] = Slide::find($req->id);
            return view($this->layout . 'create', $data);
        } else {
            return view($this->layout . 'create');
        }
    }
    public function onSave(Request $req)
    {
        $id = $req->id;
        $req->validate(
            [
                'name' => 'required',
                'image' => 'required',
            ],
            [
                'name.required' => 'field is require',
                'image.required' => 'field is require',
            ]
        );
        $items = [
            'name' => $req->name,
            'image' => $req->image ?? $req->tmp_file,
            'status' => $req->status ?? 1,
            'type' => $req->type,
        ];
        DB::beginTransaction();
        try {
            if ($id) {
                Slide::findOrFail($id)->update($items);
                $status = "Update success.";
            } else {
                Slide::create($items);
                $status = "Create success";
            }
            DB::commit();
            Session::flash('success', $status);
            if ($req->type == 'course') {
                return redirect()->route('admin-course-slide-list', 1);
            } elseif ($req->type == 'partner') {
                return redirect()->route('admin-partner-slide-list', 1);
            } else {
                return redirect()->route('admin-slide-list', 1);
            }
        } catch (\Exception $e) {
            dd($e);
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
            return redirect()->back();
        }
    }

    public function onUpdateStatus(Request $req)
    {
        $status = true;
        $item = [
            "status" => $req->status,
        ];
        DB::beginTransaction();
        try {
            $status = $req->status == 2 ? "Disable successful!" : "Enable successful!";
            Slide::where("id", $req->id)->update($item);
            DB::commit();
            Session::flash("success", $status);
        } catch (\Exception $error) {
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
        }
        return redirect()->back();
    }
}
