<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ExamAnswerSheet;
use App\Models\StudentLessonScore;
use Illuminate\Support\Facades\Session;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;


class StudentLessonScoreController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:exam-control-create', ['only' => ['onSave']]);
    }

    public function onSave(Request $req)
    {
        DB::beginTransaction();
        try {
            if ($req->to_score_exam_as) {
                foreach ($req->to_score_exam_as as $item) {
                    $data = ExamAnswerSheet::find($item);
                    $student_id = $data->exam_candidate->student_id;
                    StudentLessonScore::updateOrCreate(
                        [
                            'class_id' => $req->class_id,
                            'student_id' => $student_id,
                            'exam_answer_sheet_id' => $item,
                        ],
                        [
                            'class_id' => $req->class_id,
                            'lesson_id' => $req->to_score_lesson,
                            'student_id' => $student_id,
                            'exam_answer_sheet_id' => $item,
                        ]
                    );
                    $data = '';
                    $student_id = '';
                }
            }else {
                Session::flash('warning', 'Invalid value');
                return redirect()->back();
            }
            DB::commit();
            Session::flash('success', 'Create success!');
            return redirect()->back();
        } catch (\Exception $e) {
            dd($e);
            DB::rollBack();
            Session::flash('warning', 'Create unsuccess!');
            return redirect()->back();
        }
    }
}
