<?php


namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\StudentScore;
use App\Models\ExamScore;
use Illuminate\Support\Facades\DB;
use App\Models\Classes;
use Exception;
use Illuminate\Http\Request;

class StudentScoreController extends Controller
{
    // use for calc student score to know student pass or not
    public function setIsScorePass(int $class_id, int $student_id)
    {
        DB::beginTransaction();
        try {
            $exam_score = ExamScore::where(['class_id' => $class_id, 'student_id' => $student_id])->get();
            $class = Classes::find($class_id);
            $strucutre_program = $class->class_structure_program->structure_program;
            $lesson_n = count($strucutre_program->lesson_id);
            $cc = 0;
            foreach ($exam_score as $es) {
                $cc += $es->score;
            }
            $avg = number_format((float)$cc / $lesson_n, 2, '.', '');
            $status = 0;
            if ($avg >= 40) {

                $status = 1;
            }
            StudentScore::updateOrCreate(
                [
                    'class_id' => $class_id,
                    'student_id' => $student_id,
                ],
                [
                    'class_id' => $class_id,
                    'student_id' => $student_id,
                    'total_score' => $avg,
                    'ranking' => 1,
                    'pass_status' => $status,
                ]
            );
            // $student_ss->refresh();
            $student_score = StudentScore::where('class_id', $class_id)->orderBy('total_score', 'DESC')->get();
            $ranking = 0;
            foreach ($student_score as $ss) {
                $ss->update([
                    'ranking' => $ranking += 1,
                ]);
            }
            $ranking = 0;
            $cc = 0;
            $avg = 0;
            $status = 0;
            DB::commit();
        } catch (Exception $e) {
            DB::rollBack();
            dd($e);
        }
    }
}
