<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\StudyNote;
use App\Models\Student;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Exception;

class StudyNoteController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:study-note-view-info', ['only' => ['student']]);
        $this->middleware('permission:study-note-create', ['only' => ['onSave']]);
        $this->middleware('permission:study-note-destroy', ['only' => ['onDelete']]);
    }
    public function onSave(Request $req)
    {
        $item = [
            "class_id" => $req->class_id,
            "student_id" => $req->student_id,
            "description" => $req->description,
            "noted_date" => $req->noted_date,
        ];

        $req->validate([
            "class_id" => "required",
            "student_id" => "required",
            "description" => "required",
            "noted_date" => "required",
        ]);
        DB::beginTransaction();
        try {
            StudyNote::create($item);
            DB::commit();
            return response()->json([
                'code' => 20000,
                'message' => 'Created success',
            ]);
        } catch (Exception $e) {
            DB::rollBack();
            return response()->json([
                'code' => 40005,
                'message' => 'Created unsuccess!',
            ]);
        }
    }

    public function onDelete(Request $req)
    {
        $data = StudyNote::findOrFail($req->id);

        DB::beginTransaction();
        try {
            $data->delete();
            DB::commit();
            Session::flash('success', 'Deleted success.');
            return redirect()->back();
        } catch (Exception $e) {
            DB::rollBack();
            Session::flash('warning', 'Deleted unsuccess!');
            return response()->back();
        }
    }

    public function student()
    {
        $data = Student::find(request('student_id'))->study_notes()->where('class_id', request('class_id'))->get();
        // $stu = $data->study_notes->where('class_id', request('class_id'));
        return response()->json($data);
    }
}
