<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Trainer;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;

class TrainerController extends Controller
{
    protected $layout = 'admin::pages.trainer.';
    function __construct()
    {
        $this->middleware('permission:trainer-view', ['only' => ['index']]);
        $this->middleware('permission:trainer-create', ['only' => ['onCreate', 'onSave']]);
        $this->middleware('permission:trainer-update', ['only' => ['onCreate', 'onSave', 'onUpdateStatus']]);
    }
    public function index(Request $req)
    {
        if (!$req->id) {
            return redirect()->route('admin-trainer-list', 1);
        }
        $data['data'] = Trainer::when(filled(request('search')), function ($q) {
            $q->where(function ($q) {
                $q->where('name', 'like', '%' . request('search') . '%');
            });
        })
            ->when(request('popular'), function($q){
                $q->where(function($q){
                    if(request('popular') == 'popular'){
                        $q->where('popular', 1); 
                    }
                    if(request('popular') == 'normal'){
                        $q->where('popular', 0); 
                    }
                });
            })
            ->where('status', $req->id)
            ->orderByDesc("id")
            ->paginate(50);
        return view($this->layout . 'index', $data);
    }
    public function onCreate(Request $req)
    {
        if ($req->id) {
            $data['data'] = Trainer::find($req->id);
            return view($this->layout . 'create', $data);
        } else {
            return view($this->layout . 'create');
        }
    }
    public function onSave(Request $req)
    {
        $id = $req->id;
        $req->validate(
            [
                'name'          => 'required',
                'experience'    => 'required|lte:99|gte:0',
                'skill'         => 'required',
            ],
            [
                'experience.lte'        => 'value must be less than or equal to 99',
                'experience.gte'        => 'value must be greater or equal to 0',
                'name.required'         => 'field is require',
                'experience.required'   => 'field is require',
                'skill.required'        => 'field is require',
            ]
        );
        $items = [
            'name'       => $req->name,
            'experience' => $req->experience,
            'skill'      => $req->skill,
            'work'       => $req->work,
            'position'   => $req->position,
            'profile'    => $req->image ?? $req->tmp_file ?? null,
            'status'     => $req->status ?? 1,
            'certified'  => $req->certified ? 1 : 0,
            'popular'    => $req->popular ? 1 : 0,
        ];
        DB::beginTransaction();
        try {
            if ($id) {
                Trainer::findOrFail($id)->update($items);
                $status = "Update success.";
            } else {
                Trainer::create($items);
                $status = "Create success";
            }
            DB::commit();
            Session::flash('success', $status);
            return redirect()->route('admin-trainer-list', 1);
        } catch (\Exception $e) {
            dd($e);
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
            return redirect()->back();
        }
    }

    public function onUpdateStatus(Request $req)
    {
        $status = true;
        $item = [
            "status" => $req->status,
        ];
        DB::beginTransaction();
        try {
            $status = $req->status == 2 ? "Disable successful!" : "Enable successful!";
            Trainer::where("id", $req->id)->update($item);
            DB::commit();
            Session::flash("success", $status);
        } catch (\Exception $error) {
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
        }
        return redirect()->back();
    }
}
