<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Video;
use App\Models\Album;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;

class VideoController extends Controller
{
    protected $layout = 'admin::pages.video.';
    function __construct()
    {
        $this->middleware('permission:video-view', ['only' => ['index']]);
        $this->middleware('permission:video-create', ['only' => ['onCreate', 'onSave']]);
        $this->middleware('permission:video-update', ['only' => ['onCreate', 'onSave', 'onUpdateStatus']]);
    }
    public function index(Request $req)
    {
        if (!$req->id) {
            return redirect()->route('admin-video-list', 1);
        }
        $data['data'] = Video::when(filled(request('search')), function ($q) {
            $q->where(function ($q) {
                $q->where('name', 'like', '%' . request('search') . '%');
            });
        })
            ->where('status', $req->id)
            ->orderByDesc("id")
            ->paginate(50);
        return view($this->layout . 'index', $data);
    }
    public function onCreate(Request $req)
    {
        $data['albums'] = Album::where(['album_type' => 'Video', 'status' => 1])->get();
        if ($req->id) {
            $data['data'] = Video::find($req->id);
            return view($this->layout . 'create', $data);
        } else {
            return view($this->layout . 'create', $data);
        }
    }
    public function onSave(Request $req)
    {
        $id = $req->id;
        $req->validate(
            [
                'name' => 'required',
                'video' => 'required',
                'album_id' => 'required',
            ],
            [
                'name.required' => 'field is require',
                'video.required' => 'field is require',
                'album_id.required' => 'field is require',
            ]
        );
        $items = [
            'name' => $req->name,
            'video' => $req->video,
            'video_id' => $req->video_id,
            'cover' => $req->image ?? $req->tmp_file,
            'description' => $req->description,
            'album_id' => $req->album_id,
            'status' => $req->status ?? 1,
        ];
        DB::beginTransaction();
        try {
            if ($id) {
                Video::findOrFail($id)->update($items);
                $status = "Update success.";
            } else {
                Video::create($items);
                $status = "Create success";
            }
            DB::commit();
            Session::flash('success', $status);
            return redirect()->route('admin-video-list', 1);
        } catch (\Exception $e) {
            dd($e);
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
            return redirect()->back();
        }
    }

    public function onUpdateStatus(Request $req)
    {
        $status = true;
        $item = [
            "status" => $req->status,
        ];
        DB::beginTransaction();
        try {
            $status = $req->status == 2 ? "Disable successful!" : "Enable successful!";
            Video::where("id", $req->id)->update($item);
            DB::commit();
            Session::flash("success", $status);
        } catch (\Exception $error) {
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
        }
        return redirect()->back();
    }
}
