<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\WorkDay;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;

class WorkDayController extends Controller
{
    protected $layout = 'admin::pages.workDay.';
    function __construct()
    {
        $this->middleware('permission:work-day-view', ['only' => ['index']]);
        $this->middleware('permission:work-day-create', ['only' => ['onCreate', 'onSave']]);
        $this->middleware('permission:work-day-update', ['only' => ['onSave', 'onUpdateStatus']]);
    }
    public function index(Request $req)
    {
        if (!$req->id) {
            return redirect()->route('admin-work-day-list', 1);
        }
        $data['data'] = WorkDay::when(filled(request('search')), function ($q) {
            $q->where(function ($q) {
                $q->where('day', 'like', '%' . request('search') . '%');
            });
        })
            ->where('status', $req->id)
            ->orderByDesc("order")
            ->paginate(50);
        return view($this->layout . 'index', $data);
    }
    public function onCreate(Request $req)
    {
        $data['days'] = [
            'Monday',
            'Tuesday',
            'Wednesday',
            'Thursday',
            'Friday',
            'Saturday',
            'Sunday',
        ];
        $last_order = WorkDay::latest('order')->first();
        if ($last_order) {
            $data['order'] = (int)$last_order->order;
        } else {
            $data['order'] = 0;
        }
        if ($req->id) {
            $data['data'] = WorkDay::find($req->id);
            return view($this->layout . 'create', $data);
        } else {
            return view($this->layout . 'create', $data);
        }
    }
    public function onSave(Request $req)
    {
        $id = $req->id;
        $last_order = WorkDay::latest('order')->first();
        if ($last_order) {
            $order = (int)$last_order->order + 1;
        } else {
            $order = 0 + 1;
        }
        $req->validate(
            [
                'day' => 'required',
                'from_hour' => 'required',
                'to_hour' => 'required',
            ],
            [
                'day.required' => 'field is require',
                'from_hour.required' => 'field is require',
                'to_hour.required' => 'field is require',
            ]
        );
        $items = [
            'day' => $req->day,
            'from_hour' => $req->from_hour,
            'to_hour' => $req->to_hour,
            'status' => $req->status ?? 1,
            'order' => $req->order ?? $order,
        ];
        DB::beginTransaction();
        try {
            if ($id) {
                WorkDay::findOrFail($id)->update($items);
                $status = "Update success.";
            } else {
                WorkDay::create($items);
                $status = "Create success";
            }
            DB::commit();
            Session::flash('success', $status);
            return redirect()->route('admin-work-day-list', 1);
        } catch (\Exception $e) {
            dd($e);
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
            return redirect()->back();
        }
    }

    public function onUpdateStatus(Request $req)
    {
        $status = true;
        $item = [
            "status" => $req->status,
        ];
        DB::beginTransaction();
        try {
            $status = $req->status == 2 ? "Disable successful!" : "Enable successful!";
            WorkDay::where("id", $req->id)->update($item);
            DB::commit();
            Session::flash("success", $status);
        } catch (\Exception $error) {
            DB::rollback();
            Session::flash('warning', 'Create unsuccess!');
        }
        return redirect()->back();
    }
}