<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\WebsiteBaseController;

class GalleryController extends WebsiteBaseController
{
    protected $layout = 'website::pages.gallery.';

    public function onIndex()
    {
        try{
            $data['photos']    = $this->websiteService->queryGalleryByAlbumWithMultipleRecords('Image', 6);
            $data['videos']    = $this->websiteService->queryGalleryByAlbumWithMultipleRecords('Video', 4);

            return view($this->layout. 'index', $data);

        } catch (\Exception $e) {
            return abort(403, $this->abort);
        }

    }

    public function onPhoto($id = null)
    {
        try{
            $data['photo_details']  = $this->websiteService->queryGalleryDetailByIdWithMultipleRecords($id);
            
            return view($this->layout. 'photo', $data);

        } catch (\Exception $e) {
            return abort(403, $this->abort);
        }

    }

    public function onVideo($id = null)
    {
        try{

            $data['video_details']  = $this->websiteService->queryGalleryVideoDetailByIdWithMultipleRecords($id);
            $data['related']        = $this->websiteService->queryGalleryByAlbumWithMultipleRecords('Video', null);
            
            return view($this->layout. 'video', $data);

        } catch (\Exception $e) {
            return abort(403, $this->abort);
        }
    }
}
