<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\WebsiteBaseController;
use App\Http\Requests\Website\GetInTouchRequest;
use App\Models\UserFeedback;
use Illuminate\Http\Request;

class PageController extends WebsiteBaseController
{
    protected $layout = 'website::pages.';

    public function onAboutUs()
    {
        try{
            $data['about']          = $this->websiteService->queryAboutUsWithSingleRecord();
            $data['cover']          = $this->websiteService->queryCoverWithSingleRecord('about');
            $data['workDay']        = $this->websiteService->queryWorkDayWithMultipleRecords();
            $data['aboutHistory']   = $this->websiteService->queryAboutUsHistoryWithMultipleRecords();
            
            return view($this->layout. 'about', $data);
        } catch (\Exception $e) {
            return abort(403, $this->abort);
        }
    }

    public function onGetInTouch(GetInTouchRequest $request)
    {
        try {
            $data = [
                "name"      => $request->name,
                "phone"     => $request->phone,
                "message"   => $request->message
            ];

            UserFeedback::create($data);

            return response()->json([
                'status'   => true,
                'error'    => false,
                'message'  => 'Message sent successfully',
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'status'   => false,
                'error'    => true,
                'message'  => $e->getMessage(),
            ]);
        }
    }
}