<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\WebsiteBaseController;
use App\Models\Partner;
use Illuminate\Http\Request;

class PartnerController extends WebsiteBaseController
{
    protected $layout = 'website::pages.partner.';
    
    public function onIndex()
    {
        try{
            $data['slider']         = $this->websiteService->querySliderWithMultipleRecords();
            $data['partners'] = $this->websiteService->queryPartnerWithMultipleRecords(10);

            return view($this->layout. 'index', $data);
        } catch (\Exception $e) {
            return abort(403, $this->abort);
        }
    }
    public function onPartner()
    {
        try{
            $data['partner_list'] = $this->websiteService->queryPartnerWithMultipleRecords(6);

            // ddd($data['partner_list']);

            return view($this->layout. 'partner', $data);
        } catch (\Exception $e) {
            return abort(403, $this->abort);
        }
    }
}
