<?php

namespace App\Http\Controllers;

use App\Models\About;
use App\Models\Student;
use App\Models\User;
use App\Services\WebsiteService;
use Illuminate\Routing\Controller as BaseController;

class WebsiteBaseController extends BaseController
{
    public $abort, $categories, $user, $about, $contact, $websiteService, $workDay,$aboutHistory, $slide, $quote;
    public function __construct()
    {
        try {
            $this->abort                = 'The page you are looking for could not be found.';
            $this->websiteService       = new WebsiteService();
            $this->contact              = $this->websiteService->queryContactUsWithSingleRecord();

            $this->middleware(function ($request, $next) {
                if (auth('web')->check()) {
                    $this->user = Student::query()
                                        ->whereId(auth('web')->user()->id)
                                        ->whereStatus(config('dummy.status.active'))
                                        ->whereRole('student')
                                        ->first();

                    View()->share([
                        'user' => $this->user,
                    ]);
                }
                return $next($request);
            });
            view()->share([
                'contact'       => $this->contact,
            ]);

        } catch (\Exception $e) {
            abort(503);
        }
    }
}