<?php

namespace App\Http\Requests\Website;

use Illuminate\Foundation\Http\FormRequest;

class ResetPasswordRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        $id = auth()->guard('web')->user()->id ?? '';
        return [
            'email'                     => $id ? 'nullable':'required|string|exists:users,email',
            'password'                  => 'required|string|min:6|max:20',
            'confirm_password'          => 'required|string|same:password',
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array<string, string>
     */

    public function messages()
    {
        return [
            'email.required' => 'Please input this field',
            'email.exists' => 'This email is not found',
            'email.email' => 'Please input a valid email address',
            'password.required' => 'Please input this field',
            'password.min' => 'Password must be at least 6 characters',
            'password.max' => 'Password must be at most 20 characters',
            'confirm_password.required' => 'Please input this field',
            'confirm_password.same' => 'Password and Confirm Password does not match',
        ];
    }
}