<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Album extends Model
{
    use HasFactory;
    protected $table = 'gallery_albums';
    protected $fillable = [
        'name',
        'cover',
        'album_type',
        'status'
    ];

    public function countGallery()
    {
        return $this->hasMany(Gallery::class, 'album_id')->whereStatus(1)->count();
    }

    public function countVideo()
    {
        return $this->hasMany(Video::class, 'album_id')->whereStatus(1)->count();
    }
}
