<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AttendanceStatus extends Model
{
    use HasFactory;
    protected $table = 'attendance_status';
    protected $fillable = [
        'class_id',
        'student_id',
        'today_attended',
        'attend_amount',
        'attend_percent',
        'attend_status',
    ];
    public function classes()
    {
        return $this->belongsTo(Classes::class, 'class_id');
    }

    public function student()
    {
        return $this->belongsTo(Student::class, 'student_id');
    }
}
