<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Branch extends Model
{
    use HasFactory;
    protected $table = 'branches';
    protected $fillable = [
        'parent_id',
        'name',
        'address',
        'phone',
        'email',
        'logo',
        'website',
        'working_day',
        'working_hour',
        'status',
        'is_default',
        'user_id',
    ];

    public function branch_code(){
        return $this->hasOne(BranchCode::class, 'branch_id');
    }
    
    public function user(){
        return $this->belongsTo(User::class, 'user_id');
    }
}
