<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Classes extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'classes';
    protected $fillable = [
        'staff_id',
        'branch_id',
        'class_type_id',
        'class_level_id',
        'shift_id',
        'class_status_id',
        'class_code',
        'generation',
        'group',
        'period_duration',
        'start_date',
        'end_date',
        'url_google_sheet_edit',
        'url_google_sheet_view',
        'user_id',
        'class_cost',
        'supplies_cost',
        'total_cost',
    ];

    public function staff()
    {
        return $this->belongsTo(Staff::class);
    }
    public function class_type()
    {
        return $this->belongsTo(ClassType::class);
    }
    public function class_level()
    {
        return $this->belongsTo(ClassLevel::class);
    }
    public function class_status()
    {
        return $this->belongsTo(ClassStatus::class);
    }
    public function shift()
    {
        return $this->belongsTo(Shift::class);
    }

    public function students()
    {
        return $this->belongsToMany(Student::class, 'student_classes', 'class_id', 'student_id')->withTimestamps();
    }
    public function class_structure_program()
    {
        return $this->hasOne(ClassStructureProgram::class, 'class_id');
    }

    public function attandance()
    {
        return $this->hasMany(Attendance::class, 'class_id');
    }

    public function student_intern_places()
    {
        return $this->hasMany(StudentInternPlace::class, 'class_id');
    }
    public function groups()
    {
        return $this->hasMany(Group::class, 'class_id');
    }
    public function study_notes()
    {
        return $this->hasMany(StudyNote::class, 'class_id');
    }
    public function exam_subjects()
    {
        return $this->hasMany(ExamSubject::class, 'class_id');
    }
    public function exam_candidates()
    {
        return $this->hasMany(ExamCandidate::class, 'class_id');
    }
    public function class_image()
    {
        return $this->hasMany(ClassImage::class, 'class_id');
    }
    public function users()
    {
        return $this->belongsToMany(User::class, 'class_allow_users', 'class_id', 'user_id')->withTimestamps();
    }

    public function user(){
        return $this->belongsTo(User::class, 'user_id');
    }
}
