<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ExamCandidate extends Model
{
    use HasFactory;
    protected $table = 'exam_candidates';
    protected $fillable = [
        'class_id',
        'exam_id',
        'student_id',
    ];
    public function student()
    {
        return $this->belongsTo(Student::class, 'student_id');
    }
    public function exam_control()
    {
        return $this->belongsTo(ExamControl::class, 'exam_id');
    }
    public function classes()
    {
        return $this->belongsTo(Classes::class, 'class_id');
    }
}
