<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Group extends Model
{
    use HasFactory;
    protected $table = 'groups';
    protected $fillable = [
        'class_id',
        'name',
    ];
    public function students()
    {
        return $this->belongsToMany(Student::class, 'student_groups', 'group_id', 'student_id')->withTimestamps();
    }

    public function classes()
    {
        return $this->belongsTo(Classes::class, 'class_id');
    }
}
