<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LessonOccupation extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'lesson_occupations';
    protected $fillable = [
        'name',
        'status',
    ];
    
    public function lessons()
    {
        return $this->hasMany(Lesson::class, "lesson_occupation_id");
    }
}
