<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Staff extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'staffs';
    protected $fillable = [
        'staff_type_id',
        'staff_position_id',
        'full_name',
        'email',
        'phone',
        'gender',
        'profile',
        'status',
        'cv',
        'noted',
        'user_id',
    ];
     public function staff_position()
    {
        return $this->belongsTo(StaffPosition::class, 'staff_position_id');
    }
    public function staff_type()
    {
        return $this->belongsTo(StaffType::class, 'staff_type_id');
    }
    public function exam_subjects()
    {
        return $this->hasMany(ExamSubject::class, 'sheet_issuer_id');
    }
    public function user(){
        return $this->belongsTo(User::class, 'user_id');
    }
}
