<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;


class StaffPosition extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'staff_positions';
    public const CREATED_AT = 'created_at';
    public const UPDATED_AT = 'updated_at';
    protected $fillable = [
        'name',
        'status',
    ];

    public function staffs()
    {
        return $this->hasMany(Staff::class, 'staff_position_id');
    }
}
