<?php

namespace App\Models;

use Illuminate\Contracts\Mail\Attachable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\SoftDeletes;

class Student extends Authenticatable
{
    use HasFactory, SoftDeletes;
    protected $table = 'students';
    protected $fillable = [
        'education_level_id',
        'name_latin',
        'name_khmer',
        'dob',
        'id_card',
        'sid',
        'phone',
        'phone_with_telegram',
        'gender',
        'profile',
        'email',
        'address_khmer',
        'address_latin',
        'noted',
        'status',
        'current_working_place',
        'working_experience',
        'approval_status',
        'password',
        'role',
    ];
    protected $hidden = [
        'password',
    ];
    public function education_level()
    {
        return $this->belongsTo(EducationLevel::class, 'education_level_id');
    }
    public function classes()
    {
        return $this->belongsToMany(Classes::class, 'student_classes', 'student_id', 'class_id')->withTimestamps();
    }

    public function attendance()
    {
        return $this->hasMany(Attendance::class, 'attendance');
    }

    public function student_intern_places()
    {
        return $this->hasMany(StudentInternPlace::class, 'student_id');
    }

    public function groups()
    {
        return $this->belongsToMany(Group::class, 'student_groups', 'student_id', 'group_id')->withTimestamps();
    }

    public function study_notes()
    {
        return $this->hasMany(StudyNote::class, 'student_id');
    }
    public function exam_candidates()
    {
        return $this->hasMany(ExamCandidate::class, 'student_id');
    }
    public function attendance_statuses()
    {
        return $this->hasMany(AttendanceStatus::class, 'student_id');
    }
    public function exam_score()
    {
        return $this->hasMany(ExamScore::class, 'student_id');
    }
    public function student_score()
    {
        return $this->hasMany(StudentScore::class, 'student_id');
    }
}
