<?php

namespace App\Models;

use Illuminate\Support\Facades\File;

class UploadFile
{
    public static function uploadFile($destination, $image, $temperature = null)
    {
        if ($image != null) {
            $path = public_path() . '/' . $destination;
            $originalName = $image->getClientOriginalName();
            $fileName = time() . rand(1111, 9999) . '.' . $originalName;
            $image->move($path, $fileName);

            // if ($temperature) {
            //     $fileName = public_path() . $destination . '/' . $temperature;
            //     File::delete($fileName);
            // }
        } else {
            $fileName = $temperature;
        }
        return $fileName;
    }

    public static function deleteFile($destination, $temperature)
    {
        if ($temperature) {
            $filename = public_path() . $destination . '/' . $temperature;
            File::delete($filename);
        }
    }
}
