<?php

return [
    [
        'path' => 'admin/student/list/1',
        'active' => 'admin/student/*',
        'permission' => 'student-view',
        'name' => [
            'en' => 'Students',
        ],
        'icon' => 'users',
    ],
    // Training Program
    [
        'active' => 'admin/lesson/*,admin/program-class/*,admin/structure-program/*',
        'permission' => ['lesson-view', 'class-program-view', 'structure-program-view'],
        'name' => [
            'en' => 'Training Program',
        ],
        'icon' => 'book-open',
        'children' => [
            [
                'path' => 'admin/program-class/list/1',
                'active' => 'admin/program-class/*',
                'permission' => 'class-program-view',
                'name' => [
                    'en' => 'Class Program',
                ],
            ],
            [
                'path' => 'admin/structure-program/list/1',
                'active' => 'admin/structure-program/*',
                'permission' => 'structure-program-view',
                'name' => [
                    'en' => 'Program Structure',
                ],
            ],
            [
                'path' => 'admin/lesson/list/1',
                'active' => 'admin/lesson/*',
                'permission' => 'lesson-view',
                'name' => [
                    'en' => 'Lessons',
                ],
            ],
        ],
    ],

    // Class
    [
        'name' => [
            'en' => 'Class',
        ],
        'path' => 'admin/class/list/1',
        'active' => 'admin/class/*,admin/exam-control/*,admin/assign-internship-place/*',
        'permission' => 'class-view',
        'icon'  => 'airplay',
    ],

    // Internship Place
    [
        'name' => [
            'en' => 'Internship Place',
        ],
        'path' => 'admin/internship-place/list/1',
        'active' => 'admin/internship-place/*',
        'permission' => 'internship-place-view',
        'icon'  => 'clipboard',
    ],

    // Staff
    [
        'name' => [
            'en' => 'Staff',
        ],
        'path' => 'admin/staff/list/1',
        'active' => 'admin/staff/*',
        'permission' => 'staff-view',
        'icon'  => 'users',
    ],

    // Branch
    [
        'name' => [
            'en' => 'Branch',
        ],
        'path' => 'admin/branch/list/1',
        'active' => 'admin/branch/*',
        'permission' => 'branch-view',
        'icon'  => 'map',
    ],

    // user
    [
        'path' => 'admin/user/list/1',
        'active' => 'admin/user/*',
        'permission' => 'user-view',
        'name' => [
            'en' => 'User',
        ],
        'icon' => 'user',
    ],
    // Feature
    [
        'active' => 'admin/class-type/*,admin/class-status/*,admin/class-level/*,admin/shift/*,admin/exam-type/*,admin/education/*,admin/occupation/*,admin/staff-type/*,admin/class-occupation/*,admin/exam-control/*,admin/assign-internship-place/*,admin/study-score/*,admin/staff-position/*',
        'permission' => ['class-type-view', 'class-status-view', 'class-level-view', 'shift-view', 'education-view', 'occupation-view', 'staff-type-view', 'class-occupation', 'exam-control', 'study-score-view', 'exam-type-view', 'staff-position-view'],
        'name' => [
            'en' => 'Feature',
        ],
        'icon' => 'list',
        'children' => [
            [
                'path' => 'admin/education/list/1',
                'active' => 'admin/education/*',
                'permission' => 'education-view',
                'name' => [
                    'en' => 'Education',
                ],
            ],
            [
                'path' => 'admin/occupation/list/1',
                'active' => 'admin/occupation/*',
                'permission' => 'occupation-view',
                'name' => [
                    'en' => 'Lesson Occupation',
                ],
            ],
            [
                'path' => 'admin/class-occupation/list/1',
                'active' => 'admin/class-occupation/*',
                'permission' => 'class-occupation-view',
                'name' => [
                    'en' => 'Class Occupation',
                ],
            ],
            [
                'path' => 'admin/class-type/list/1',
                'active' => 'admin/class-type/*',
                'permission' => 'class-type-view',
                'name' => [
                    'en' => 'Class Type',
                ],
            ],
            [
                'path' => 'admin/class-status/list/1',
                'active' => 'admin/class-status/*',
                'permission' => 'class-status-view',
                'name' => [
                    'en' => 'Class Status',
                ],
            ],
            [
                'path' => 'admin/class-level/list/1',
                'active' => 'admin/class-level/*',
                'permission' => 'class-level-view',
                'name' => [
                    'en' => 'Class Level',
                ],
            ],
            [
                'path' => 'admin/shift/list/1',
                'active' => 'admin/shift/*',
                'permission' => 'shift-view',
                'name' => [
                    'en' => 'Shift',
                ],
            ],
            [
                'name' => [
                    'en' => 'Exam Type',
                ],
                'path' => 'admin/exam-type/list/1',
                'active' => 'admin/exam-type/*',
                'permission' => 'exam-type-view',
                'icon'  => 'file-plus',
            ],
            [
                'path' => 'admin/staff-type/list/1',
                'active' => 'admin/staff-type/*',
                'permission' => 'staff-type-view',
                'name' => [
                    'en' => 'Staff Category',
                ],
            ],
            [
                'name' => [
                    'en' => 'Competency Type',
                ],
                'path' => 'admin/study-score/list/1',
                'active' => 'admin/study-score/*',
                'permission' => 'study-score-view',
                'icon'  => 'hash',
            ],
            [
                'path' => 'admin/staff-position/list/1',
                'active' => 'admin/staff-position/*',
                'permission' => 'staff-position-view',
                'name' => [
                    'en' => 'Staff Position',
                ],
            ],
        ],
    ],
    // Home
    [
        'active' => 'admin/contact/*,admin/slide/*,admin/qoute/*,admin/question/*,admin/user-feedback/*',
        'permission' => ['contact-create', 'slide-view', 'qoute-view', 'question-view', 'user-feedback-view'],
        'name' => [
            'en' => 'Home',
        ],
        'icon' => 'home',
        'children' => [
            [
                'path' => 'admin/contact/create',
                'active' => 'admin/contact/create',
                'permission' => 'contact-create',
                'name' => [
                    'en' => 'Contact',

                ],
            ],
            [
                'path' => 'admin/contact/cover/create',
                'active' => 'admin/contact/cover/create',
                'permission' => 'contact-cover-create',
                'name' => [
                    'en' => 'Cover',

                ],
            ],
            [
                'path' => 'admin/slide/list/1',
                'active' => 'admin/slide/*',
                'permission' => 'slide-view',
                'name' => [
                    'en' => 'Image Slide',
                ],
            ],
            [
                'path' => 'admin/qoute/list/1',
                'active' => 'admin/qoute/*',
                'permission' => 'qoute-view',
                'name' => [
                    'en' => 'Qoute',
                ],
            ],
            [
                'path' => 'admin/question/list/1',
                'active' => 'admin/question/*',
                'permission' => 'question-view',
                'name' => [
                    'en' => 'Question',
                ],
            ],
            [
                'path' => 'admin/user-feedback/list/1',
                'active' => 'admin/user-feedback/*',
                'permission' => 'user-feedback-view',
                'name' => [
                    'en' => 'User Feedback',
                ],
            ],
        ],
    ],
    // Course
    [
        'active' => 'admin/trainer/*,admin/course/*',
        'permission' => ['traner-view', 'course-view'],
        'name' => [
            'en' => 'Course',
        ],
        'icon' => 'folder-plus',
        'children' => [
            // [
            //     'path' => 'admin/course/slide/list/1',
            //     'active' => 'admin/course/slide/*',
            //     'permission' => 'traner-view',
            //     'name' => [
            //         'en' => 'Image Slide',
            //     ],
            // ],
            [
                'path' => 'admin/trainer/list/1',
                'active' => 'admin/trainer/*',
                'permission' => 'traner-view',
                'name' => [
                    'en' => 'Trainer',
                ],
            ],
            [
                'path' => 'admin/course/list/1',
                'active' => 'admin/course/*',
                'permission' => 'course-view',
                'name' => [
                    'en' => 'Course',
                ],
            ],
        ]
    ],
    // Partner
    [
        'active' => 'admin/partner/*',
        'permission' => 'partner-view',
        'name' => [
            'en' => 'Partner',
        ],
        'icon' => 'user-plus',
        'children' => [
            // [
            //     'path' => 'admin/partner/slide/list/1',
            //     'active' => 'admin/partner/slide/*',
            //     'permission' => 'partner-slide-view',
            //     'name' => [
            //         'en' => 'Image Slide',
            //     ],
            // ],
            [
                'path' => 'admin/partner/list/1',
                'active' => 'admin/partner/list/*,admin/partner/create/*',
                'permission' => 'partner-view',
                'name' => [
                    'en' => 'Partner',
                ],
            ],
        ]
    ],
    // Gallery
    [
        'active' => 'admin/album/*,admin/gallery/*,admin/video/*',
        'permission' => ['album-view', 'gallery-view', 'video-view'],
        'name' => [
            'en' => 'Gallery'
        ],
        'icon' => 'image',
        'children' => [
            [
                'path' => 'admin/album/list/1',
                'active' => 'admin/album/*',
                'permission' => 'album-view',
                'name' => [
                    'en' => 'Gallery Album',
                ],
            ],
            [
                'path' => 'admin/gallery/list/1',
                'active' => 'admin/gallery/*',
                'permission' => 'gallery-view',
                'name' => [
                    'en' => 'Gallery Image',
                ],
            ],
            [
                'path' => 'admin/video/list/1',
                'active' => 'admin/video/*',
                'permission' => 'video-view',
                'name' => [
                    'en' => 'Gallery Video',
                ],
            ],
        ]
    ],
    // Training Video
    [
        'active' => 'admin/category/*,admin/training-video/*',
        'permission' => ['category-view', 'training-video-view'],
        'name' => [
            'en' => 'Training Video'
        ],
        'icon' => 'video',
        'children' => [
            [
                'path' => 'admin/category/list/1',
                'active' => 'admin/category/*',
                'permission' => 'category-view',
                'name' => [
                    'en' => 'Training Video Category',
                ],
            ],
            [
                'path' => 'admin/training-video/list/1',
                'active' => 'admin/training-video/*',
                'permission' => 'training-video-view',
                'name' => [
                    'en' => 'Training Video',
                ],
            ],
        ]
    ],
    // About
    [
        'active' => 'admin/cover/*,admin/about/*,admin/about/child/*,admin/work-day/*',
        'permission' => ['work-day-view', 'about-child-view', 'about-create', 'cover'],
        'name' => [
            'en' => 'About'
        ],
        'icon' => 'target',
        'children' => [
            [
                'path' => 'admin/about/cover/create',
                'active' => 'admin/about/cover/create',
                'permission' => 'about-cover-create',
                'name' => [
                    'en' => 'Cover',
                ],

            ],
            [
                'path' => 'admin/about/create',
                'active' => 'admin/about/create',
                'permission' => 'about-create',
                'name' => [
                    'en' => 'About',
                ],

            ],
            [
                'path' => 'admin/about/child/list/1',
                'active' => 'admin/about/child/*',
                'permission' => 'about-child-view',
                'name' => [
                    'en' => 'Sub About',
                ],
            ],
            [
                'path' => 'admin/work-day/list/1',
                'active' => 'admin/work-day/*',
                'permission' => 'work-day-view',
                'name' => [
                    'en' => 'Work Day',
                ],
            ],
        ]
    ],
];
