<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('class_structure_programs', function (Blueprint $table) {
            $table->id();
            $table->integer('class_id');
            $table->integer('structure_program_id');
            $table->float('generic_full_score');
            $table->float('functional_full_score');
            $table->integer('generic_subject')->default(0);
            $table->integer('functional_subject')->default(0);
            $table->float('each_generic_score');
            $table->float('each_functional_score');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('class_structure_programs');
    }
};
